/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InferredEntityAxiomGenerator<E extends OWLEntity, A extends OWLAxiom>
implements InferredAxiomGenerator<A> {
    @Override
    public Set<A> createAxioms(OWLOntologyManager manager, OWLReasoner reasoner) {
        HashSet<OWLEntity> processedEntities = new HashSet<OWLEntity>();
        HashSet result = new HashSet();
        for (OWLOntology ont : reasoner.getRootOntology().getImportsClosure()) {
            for (OWLEntity entity : this.getEntities(ont)) {
                if (processedEntities.contains(entity)) continue;
                processedEntities.add(entity);
                this.addAxioms(entity, reasoner, manager.getOWLDataFactory(), result);
            }
        }
        return result;
    }

    protected abstract void addAxioms(E var1, OWLReasoner var2, OWLDataFactory var3, Set<A> var4);

    protected abstract Set<E> getEntities(OWLOntology var1);

    protected Set<E> getAllEntities(OWLReasoner reasoner) {
        HashSet<E> results = new HashSet<E>();
        for (OWLOntology ont : reasoner.getRootOntology().getImportsClosure()) {
            results.addAll(this.getEntities(ont));
        }
        return results;
    }

    public String toString() {
        return this.getLabel();
    }
}

