/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.manchesterowlsyntax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxParserException;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class ManchesterOWLSyntaxOntologyParser
extends AbstractOWLParser {
    private static final String COMMENT_START_CHAR = "#";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        try {
            BufferedReader br = null;
            try {
                String line;
                br = documentSource.isReaderAvailable() ? new BufferedReader(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new BufferedReader(new InputStreamReader(documentSource.getInputStream())) : new BufferedReader(new InputStreamReader(this.getInputStream(documentSource.getDocumentIRI()))));
                StringBuilder sb = new StringBuilder();
                int lineCount = 1;
                boolean foundMagicNumber = false;
                while ((line = br.readLine()) != null) {
                    String trimmedLine;
                    sb.append(line);
                    sb.append("\n");
                    if (!foundMagicNumber && (trimmedLine = line.trim()).length() > 0 && !trimmedLine.startsWith(COMMENT_START_CHAR)) {
                        if (this.startsWithMagicNumber(line)) {
                            foundMagicNumber = true;
                        } else {
                            int startCol = line.indexOf(trimmedLine) + 1;
                            StringBuilder msg = new StringBuilder();
                            msg.append("Encountered '");
                            msg.append(trimmedLine);
                            msg.append("' at line ");
                            msg.append(lineCount);
                            msg.append(" column ");
                            msg.append(startCol);
                            msg.append(".  Expected either 'Ontology:' or 'Prefix:'");
                            throw new ManchesterOWLSyntaxParserException(msg.toString(), lineCount, startCol);
                        }
                    }
                    ++lineCount;
                }
                String s = sb.toString();
                ManchesterOWLSyntaxEditorParser parser = new ManchesterOWLSyntaxEditorParser(this.getOWLOntologyManager().getOWLDataFactory(), s);
                parser.parseOntology(this.getOWLOntologyManager(), ontology);
            }
            finally {
                br.close();
            }
            return new ManchesterOWLSyntaxOntologyFormat();
        }
        catch (ParserException e) {
            throw new ManchesterOWLSyntaxParserException(e.getMessage(), e.getLineNumber(), e.getColumnNumber());
        }
    }

    private boolean startsWithMagicNumber(String line) {
        return line.indexOf(ManchesterOWLSyntax.PREFIX.toString()) != -1 || line.indexOf(ManchesterOWLSyntax.ONTOLOGY.toString()) != -1;
    }
}

