/*
 * (c) Copyright IBM Corp 2004, 2005 
 */

package edu.uga.cs.lsdis.meteors.wadls.extensions.schema;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;

import edu.uga.cs.lsdis.meteors.wadls.Constants;

/**
 * Constants used for handling XML Schemas
 * 
 * @author Zixin Wu (wuzixin@uga.edu)
 * @author John Kaputin <kaputin@uk.ibm.com>
 */
public class SchemaConstants {

    //Schema attribute names
    public static final String ATTR_ID = "id";
    public static final String ATTR_SCHEMA_LOCATION = "schemaLocation";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_REF = "ref";
    public static final String ATTR_BASE = "base";
    public static final String ATTR_MAXOCCURS = "maxOccurs";
    public static final String ATTR_MINOCCURS = "minOccurs";
    
    //Schema element names
    public static final String ELEM_SCHEMA = "schema";
    public static final String ELEM_INCLUDE = "include";
    public static final String ELEM_REDEFINE = "redefine";
    public static final String ELEM_ELEMENT = "element";
    public static final String ELEM_SIMPLETYPE = "simpleType";
    public static final String ELEM_COMPLEXTYPE = "complexType";
    public static final String ELEM_ALL = "all";
    public static final String ELEM_SEQUENCE = "sequence";
    public static final String ELEM_CHOICE = "choice";
    public static final String ELEM_COMPLEXCONTENT = "complexContent";
    public static final String ELEM_RESTRICTION = "restriction";
    public static final String ELEM_EXTENSION = "extension";
    public static final String ELEM_GROUP = "group";
    
    //Schema uri
    public static final String NS_URI_XSD_1998 =
        "http://www.w3.org/XML/1998/namespace";
    public static final String NS_URI_WADL =
        "http://wadl.dev.java.net/2009/02";
    public static final String NS_URI_XSD_1999 =
        "http://www.w3.org/1999/XMLSchema";
    public static final String NS_URI_XSD_2000 =
        "http://www.w3.org/2000/10/XMLSchema";
    public static final String NS_URI_XSD_2001 =
        "http://www.w3.org/2001/XMLSchema";
    public static final List XSD_STR_LIST = Arrays.asList(new String[]
		{NS_URI_XSD_1998, NS_URI_XSD_1999, NS_URI_XSD_2000, NS_URI_XSD_2001});
    
    //Schema qnames
    public static final QName Q_ELEM_XSD_1999 =
        new QName(NS_URI_XSD_1999, ELEM_SCHEMA);
    public static final QName Q_ELEM_XSD_2000 =
        new QName(NS_URI_XSD_2000, ELEM_SCHEMA);
    public static final QName Q_ELEM_XSD_2001 =
        new QName(NS_URI_XSD_2001, ELEM_SCHEMA);
    public static final List XSD_QNAME_LIST = Arrays.asList(new QName[]
        {Q_ELEM_XSD_1999, Q_ELEM_XSD_2000, Q_ELEM_XSD_2001});
    
    //Schema import qnames
    public static final QName Q_ELEM_IMPORT_XSD_1999 = new QName(
        NS_URI_XSD_1999, Constants.ELEM_IMPORT);
    public static final QName Q_ELEM_IMPORT_XSD_2000 = new QName(
        NS_URI_XSD_2000, Constants.ELEM_IMPORT);
    public static final QName Q_ELEM_IMPORT_XSD_2001 = new QName(
        NS_URI_XSD_2001, Constants.ELEM_IMPORT);
    public static final List XSD_IMPORT_QNAME_LIST = Arrays.asList(new QName[] 
        { Q_ELEM_IMPORT_XSD_1999, Q_ELEM_IMPORT_XSD_2000, Q_ELEM_IMPORT_XSD_2001 });


    //Schema include qnames
    public static final QName Q_ELEM_INCLUDE_XSD_1999 = new QName(
        NS_URI_XSD_1999, ELEM_INCLUDE);
    public static final QName Q_ELEM_INCLUDE_XSD_2000 = new QName(
        NS_URI_XSD_2000, ELEM_INCLUDE);
    public static final QName Q_ELEM_INCLUDE_XSD_2001 = new QName(
        NS_URI_XSD_2001, ELEM_INCLUDE);
    public static final QName Q_ELEM_INCLUDE_WADL = new QName(
            NS_URI_WADL, ELEM_INCLUDE);
    
    public static final List XSD_INCLUDE_QNAME_LIST = Arrays.asList(new QName[]
        { Q_ELEM_INCLUDE_XSD_1999, Q_ELEM_INCLUDE_XSD_2000, Q_ELEM_INCLUDE_XSD_2001,Q_ELEM_INCLUDE_WADL });

    //Schema redefine qnames
    public static final QName Q_ELEM_REDEFINE_XSD_1999 = new QName(
        NS_URI_XSD_1999, ELEM_REDEFINE);
    public static final QName Q_ELEM_REDEFINE_XSD_2000 = new QName(
        NS_URI_XSD_2000, ELEM_REDEFINE);
    public static final QName Q_ELEM_REDEFINE_XSD_2001 = new QName(
	    NS_URI_XSD_2001, ELEM_REDEFINE);
    public static final List XSD_REDEFINE_QNAME_LIST = Arrays.asList(new QName[]
	    { Q_ELEM_REDEFINE_XSD_1999, Q_ELEM_REDEFINE_XSD_2000, Q_ELEM_REDEFINE_XSD_2001 });


}
