
package javax.wadls;



import org.w3c.dom.Element;

/**
 * This interface represents a precondition.
 *
 * @author Zixin Wu
 */
public interface PreCondition extends java.io.Serializable,ModelReferenceExtensible
{
		
	/**
	 * Set the expression of this precondition.
	 *
	 * @param expression The desired expression.
	 */
	public void setExpression(String expression);
	
	/**
	 * Get the expression of this precondition.
	 *
	 * @return The expression.
	 */
	public String getExpression();
	
    public void setName(String name);
	
	/**
	 * Get the name of this precondition.
	 *
	 * @return the precondition name
	 */
	public String getName();
	
	public void setDocumentationElement(Element docEl);
	
	/**
	 * Get the documentation element. This dependency on org.w3c.dom.Element
	 * should eventually be removed when a more appropriate way of
	 * representing this information is employed.
	 *
	 * @return the documentation element
	 */
	public Element getDocumentationElement();
}
