/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;

public class FileDocumentSource
implements OWLOntologyDocumentSource {
    private File file;

    public FileDocumentSource(File file) {
        this.file = file;
    }

    public IRI getDocumentIRI() {
        return IRI.create(this.file);
    }

    public boolean isInputStreamAvailable() {
        return true;
    }

    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    public boolean isReaderAvailable() {
        return true;
    }

    public Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }
}

