/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryClassAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEquivalentClassesAxiomImpl
extends OWLNaryClassAxiomImpl
implements OWLEquivalentClassesAxiom {
    private Set<OWLClass> namedClasses = null;

    public OWLEquivalentClassesAxiomImpl(OWLDataFactory dataFactory, Set<? extends OWLClassExpression> classExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory, classExpressions, annotations);
    }

    @Override
    public OWLEquivalentClassesAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return this.getOWLDataFactory().getOWLEquivalentClassesAxiom(this.getClassExpressions());
    }

    @Override
    public OWLEquivalentClassesAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return this.getOWLDataFactory().getOWLEquivalentClassesAxiom(this.getClassExpressions(), this.mergeAnnos(annotations));
    }

    @Override
    public Set<OWLEquivalentClassesAxiom> asPairwiseAxioms() {
        ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(this.getClassExpressions());
        HashSet<OWLEquivalentClassesAxiom> result = new HashSet<OWLEquivalentClassesAxiom>();
        for (int i = 0; i < classExpressions.size() - 1; ++i) {
            OWLClassExpression ceI = (OWLClassExpression)classExpressions.get(i);
            OWLClassExpression ceJ = (OWLClassExpression)classExpressions.get(i + 1);
            result.add(this.getOWLDataFactory().getOWLEquivalentClassesAxiom(ceI, ceJ));
        }
        return result;
    }

    @Override
    public boolean containsNamedEquivalentClass() {
        return !this.getNamedClasses().isEmpty();
    }

    @Override
    public boolean containsOWLNothing() {
        for (OWLClassExpression desc : this.getClassExpressions()) {
            if (!desc.isOWLNothing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsOWLThing() {
        for (OWLClassExpression desc : this.getClassExpressions()) {
            if (!desc.isOWLThing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLClass> getNamedClasses() {
        if (this.namedClasses == null) {
            HashSet<OWLClass> clses = new HashSet<OWLClass>(1);
            for (OWLClassExpression desc : this.getClassExpressions()) {
                if (desc.isAnonymous() || desc.isOWLNothing() || desc.isOWLThing()) continue;
                clses.add(desc.asOWLClass());
            }
            this.namedClasses = Collections.unmodifiableSet(clses);
        }
        return this.namedClasses;
    }

    @Override
    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        for (OWLClassExpression descA : this.getClassExpressions()) {
            for (OWLClassExpression descB : this.getClassExpressions()) {
                if (descA.equals(descB)) continue;
                result.add(this.getOWLDataFactory().getOWLSubClassOfAxiom(descA, descB));
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return obj instanceof OWLEquivalentClassesAxiom;
        }
        return false;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.EQUIVALENT_CLASSES;
    }
}

