/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.schema.SchemaConstants;
import org.apache.woden.internal.wsdl20.BindingFaultImpl;
import org.apache.woden.internal.wsdl20.BindingFaultReferenceImpl;
import org.apache.woden.internal.wsdl20.BindingImpl;
import org.apache.woden.internal.wsdl20.BindingMessageReferenceImpl;
import org.apache.woden.internal.wsdl20.BindingOperationImpl;
import org.apache.woden.internal.wsdl20.DescriptionImpl;
import org.apache.woden.internal.wsdl20.ElementDeclarationImpl;
import org.apache.woden.internal.wsdl20.EndpointImpl;
import org.apache.woden.internal.wsdl20.InterfaceImpl;
import org.apache.woden.internal.wsdl20.InterfaceOperationImpl;
import org.apache.woden.internal.wsdl20.ServiceImpl;
import org.apache.woden.internal.wsdl20.TypeDefinitionImpl;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.ComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.extensions.WSDLExtensionConstants;
import org.apache.woden.wsdl20.extensions.rpc.RPCConstants;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingFaultReferenceElement;
import org.apache.woden.wsdl20.xml.BindingMessageReferenceElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

public class ComponentModelBuilder {
    private static final String emptyString = "".intern();
    private DescriptionImpl fDesc;
    private List fDescTypesDone = new Vector();
    private List fSchemasDone = new Vector();
    private List fInterfacesDone = new Vector();
    private List fBindingsDone = new Vector();
    private List fServicesDone = new Vector();
    private URI fBindingType = null;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$InterfaceOperation;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$Binding;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$BindingFault;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$BindingOperation;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$BindingMessageReference;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$BindingFaultReference;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$Endpoint;

    public ComponentModelBuilder(DescriptionImpl desc) {
        this.fDesc = desc;
        this.initComponents(this.fDesc);
    }

    private void initComponents(DescriptionImpl desc) {
        this.buildElementsAndTypes(desc);
        this.buildInterfaces(desc);
        this.buildBindings(desc);
        this.buildServices(desc);
        IncludeElement[] includes = desc.getIncludeElements();
        for (int i = 0; i < includes.length; ++i) {
            DescriptionElement inclDesc = includes[i].getDescriptionElement();
            if (inclDesc == null) continue;
            this.initComponents((DescriptionImpl)inclDesc);
        }
        ImportElement[] imports = desc.getImportElements();
        for (int i = 0; i < imports.length; ++i) {
            DescriptionElement impDesc = imports[i].getDescriptionElement();
            if (impDesc == null) continue;
            this.initComponents((DescriptionImpl)impDesc);
        }
    }

    private void buildElementsAndTypes(DescriptionImpl desc) {
        int i;
        if (this.fDescTypesDone.contains(desc)) {
            return;
        }
        this.fDescTypesDone.add(desc);
        URI typeSystemURI = URI.create("http://www.w3.org/2001/XMLSchema");
        TypesElement types = desc.getTypesElement();
        if (types != null) {
            ImportedSchema[] importedSchemas = types.getImportedSchemas();
            Vector<String> importedNSpaces = new Vector<String>();
            for (int j = 0; j < importedSchemas.length; ++j) {
                String ns;
                URI nsURI = importedSchemas[j].getNamespace();
                if (nsURI == null || importedNSpaces.contains(ns = nsURI.toString())) continue;
                importedNSpaces.add(ns);
            }
            Schema[] schemas = types.getSchemas();
            for (i = 0; i < schemas.length; ++i) {
                XmlSchema xmlSchema = schemas[i].getSchemaDefinition();
                if (xmlSchema == null || this.fSchemasDone.contains(xmlSchema)) continue;
                this.buildElementsAndTypes(xmlSchema, xmlSchema.getTargetNamespace(), typeSystemURI, importedNSpaces);
            }
        }
        IncludeElement[] includes = desc.getIncludeElements();
        for (int i2 = 0; i2 < includes.length; ++i2) {
            DescriptionElement includedDesc = includes[i2].getDescriptionElement();
            if (includedDesc == null) continue;
            this.buildElementsAndTypes((DescriptionImpl)includedDesc);
        }
        ImportElement[] imports = desc.getImportElements();
        for (i = 0; i < imports.length; ++i) {
            DescriptionElement importedDesc = imports[i].getDescriptionElement();
            if (importedDesc == null) continue;
            this.buildElementsAndTypes((DescriptionImpl)importedDesc);
        }
    }

    private void buildElementsAndTypes(XmlSchema schemaDef, String schemaTns, URI typeSystemURI, List importedNSpaces) {
        if (this.fSchemasDone.contains(schemaDef)) {
            return;
        }
        this.fSchemasDone.add(schemaDef);
        if (!"http://www.w3.org/2001/XMLSchema".equals(schemaDef.getTargetNamespace())) {
            this.buildElementDeclarations(schemaDef, schemaTns, typeSystemURI);
        }
        this.buildTypeDefinitions(schemaDef, schemaTns, typeSystemURI);
        XmlSchemaObjectCollection includeColl = schemaDef.getIncludes();
        Iterator includes = includeColl.getIterator();
        while (includes.hasNext()) {
            Object o = includes.next();
            XmlSchemaExternal externalSchema = (XmlSchemaExternal)o;
            XmlSchema schema = externalSchema.getSchema();
            if (schema == null) continue;
            String schemaTNS = schema.getTargetNamespace();
            if (!(externalSchema instanceof XmlSchemaInclude) && (!(externalSchema instanceof XmlSchemaImport) || !importedNSpaces.contains(schemaTNS))) continue;
            this.buildElementsAndTypes(schema, schemaTNS, typeSystemURI, importedNSpaces);
        }
    }

    private void buildElementDeclarations(XmlSchema schemaDef, String schemaTns, URI typeSystemURI) {
        XmlSchemaObjectTable elementTable = schemaDef.getElements();
        NamespacePrefixList prefixes = schemaDef.getNamespaceContext();
        Iterator qnames = elementTable.getNames();
        while (qnames.hasNext()) {
            String pfx;
            QName xseQN = (QName)qnames.next();
            if (this.fDesc.getElementDeclaration(xseQN) != null) continue;
            QName edQN = xseQN;
            if (xseQN.getNamespaceURI() == null && schemaTns != null) {
                edQN = new QName(schemaTns, xseQN.getLocalPart(), xseQN.getPrefix());
            }
            if ((edQN.getPrefix() == "" || edQN.getPrefix() == null) && (pfx = prefixes.getPrefix(edQN.getNamespaceURI())) != null) {
                edQN = new QName(edQN.getNamespaceURI(), edQN.getLocalPart(), pfx);
            }
            if (schemaTns != null && !schemaTns.equals(edQN.getNamespaceURI())) continue;
            ElementDeclarationImpl ed = new ElementDeclarationImpl();
            ed.setName(edQN);
            ed.setSystem(typeSystemURI);
            ed.setContentModel("org.apache.ws.commons.schema");
            ed.setContent(elementTable.getItem(xseQN));
            this.fDesc.addElementDeclaration(ed);
        }
    }

    private void buildTypeDefinitions(XmlSchema schemaDef, String schemaTns, URI typeSystemURI) {
        XmlSchemaObjectTable typeTable = schemaDef.getSchemaTypes();
        NamespacePrefixList prefixes = schemaDef.getNamespaceContext();
        Iterator qnames = typeTable.getNames();
        while (qnames.hasNext()) {
            String pfx;
            QName xstQN = (QName)qnames.next();
            if ("http://www.w3.org/2001/XMLSchema".equals(schemaTns) && !SchemaConstants.LIST_Q_BUILT_IN_TYPES.contains(xstQN) || this.fDesc.getTypeDefinition(xstQN) != null) continue;
            QName tdQN = xstQN;
            if (xstQN.getNamespaceURI() == null && schemaTns != null) {
                tdQN = new QName(schemaTns, xstQN.getLocalPart(), xstQN.getPrefix());
            }
            if ((tdQN.getPrefix() == emptyString || tdQN.getPrefix() == null) && (pfx = prefixes.getPrefix(tdQN.getNamespaceURI())) != null) {
                tdQN = new QName(tdQN.getNamespaceURI(), tdQN.getLocalPart(), pfx);
            }
            if (schemaTns != null && !schemaTns.equals(tdQN.getNamespaceURI())) continue;
            TypeDefinitionImpl td = new TypeDefinitionImpl();
            td.setName(tdQN);
            td.setSystem(typeSystemURI);
            td.setContentModel("org.apache.ws.commons.schema");
            td.setContent(typeTable.getItem(xstQN));
            this.fDesc.addTypeDefinition(td);
        }
    }

    private void buildInterfaces(DescriptionImpl desc) {
        InterfaceElement[] interfaceEls = desc.getInterfaceElements();
        for (int i = 0; i < interfaceEls.length; ++i) {
            InterfaceImpl interfaceImpl = (InterfaceImpl)interfaceEls[i];
            if (this.fInterfacesDone.contains(interfaceImpl)) continue;
            this.buildInterfaceOperations(interfaceImpl);
            this.fInterfacesDone.add(interfaceImpl);
        }
    }

    private void buildInterfaceOperations(InterfaceImpl interfaceImpl) {
        InterfaceOperationElement[] operations = interfaceImpl.getInterfaceOperationElements();
        for (int i = 0; i < operations.length; ++i) {
            InterfaceOperationImpl oper = (InterfaceOperationImpl)operations[i];
            this.buildInterfaceOperationExtensions(oper);
        }
    }

    private void buildInterfaceOperationExtensions(InterfaceOperationImpl oper) {
        ExtensionRegistry er = this.fDesc.getWsdlContext().extensionRegistry;
        URI[] extNamespaces = er.queryComponentExtensionNamespaces(class$org$apache$woden$wsdl20$InterfaceOperation == null ? (class$org$apache$woden$wsdl20$InterfaceOperation = ComponentModelBuilder.class$("org.apache.woden.wsdl20.InterfaceOperation")) : class$org$apache$woden$wsdl20$InterfaceOperation);
        for (int i = 0; i < extNamespaces.length; ++i) {
            URI extNS = extNamespaces[i];
            if (!oper.hasExtensionAttributesForNamespace(extNS)) continue;
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$InterfaceOperation == null ? ComponentModelBuilder.class$("org.apache.woden.wsdl20.InterfaceOperation") : class$org$apache$woden$wsdl20$InterfaceOperation, oper, extNS);
            oper.setComponentExtensionContext(extNS, compExt);
        }
        if (oper.getComponentExtensionContext(WSDLExtensionConstants.NS_URI_WSDL_EXTENSIONS) == null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$InterfaceOperation == null ? (class$org$apache$woden$wsdl20$InterfaceOperation = ComponentModelBuilder.class$("org.apache.woden.wsdl20.InterfaceOperation")) : class$org$apache$woden$wsdl20$InterfaceOperation, oper, WSDLExtensionConstants.NS_URI_WSDL_EXTENSIONS);
            oper.setComponentExtensionContext(WSDLExtensionConstants.NS_URI_WSDL_EXTENSIONS, compExt);
        }
        boolean isRPCStyle = false;
        URI[] style = oper.getStyle();
        for (int i = 0; i < style.length; ++i) {
            URI temp = style[i];
            if (!RPCConstants.STYLE_URI_RPC.equals(temp)) continue;
            isRPCStyle = true;
            break;
        }
        if (isRPCStyle && oper.getComponentExtensionContext(RPCConstants.NS_URI_RPC) == null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$InterfaceOperation == null ? (class$org$apache$woden$wsdl20$InterfaceOperation = ComponentModelBuilder.class$("org.apache.woden.wsdl20.InterfaceOperation")) : class$org$apache$woden$wsdl20$InterfaceOperation, oper, RPCConstants.NS_URI_RPC);
            oper.setComponentExtensionContext(RPCConstants.NS_URI_RPC, compExt);
        }
    }

    private void buildBindings(DescriptionImpl desc) {
        BindingElement[] bindingEls = desc.getBindingElements();
        for (int i = 0; i < bindingEls.length; ++i) {
            BindingImpl bindImpl = (BindingImpl)bindingEls[i];
            if (this.fBindingsDone.contains(bindImpl)) continue;
            this.buildBindingExtensions(bindImpl);
            this.buildBindingFaults(bindImpl);
            this.buildBindingOperations(bindImpl);
            this.fBindingsDone.add(bindImpl);
        }
    }

    private void buildBindingFaults(BindingImpl binding) {
        BindingFaultElement[] bindFaults = binding.getBindingFaultElements();
        for (int i = 0; i < bindFaults.length; ++i) {
            BindingFaultImpl bindFault = (BindingFaultImpl)bindFaults[i];
            this.buildBindingFaultExtensions(bindFault);
        }
    }

    private void buildBindingOperations(BindingImpl binding) {
        BindingOperationElement[] operations = binding.getBindingOperationElements();
        for (int i = 0; i < operations.length; ++i) {
            BindingOperationImpl oper = (BindingOperationImpl)operations[i];
            this.buildBindingFaultReferences(oper);
            this.buildBindingMessageReferences(oper);
            this.buildBindingOperationExtensions(oper);
        }
    }

    private void buildBindingFaultReferences(BindingOperationImpl oper) {
        BindingFaultReferenceElement[] faultRefs = oper.getBindingFaultReferenceElements();
        for (int i = 0; i < faultRefs.length; ++i) {
            BindingFaultReferenceImpl faultRef = (BindingFaultReferenceImpl)faultRefs[i];
            this.buildBindingFaultReferenceExtensions(faultRef);
        }
    }

    private void buildBindingMessageReferences(BindingOperationImpl oper) {
        BindingMessageReferenceElement[] messages = oper.getBindingMessageReferenceElements();
        for (int i = 0; i < messages.length; ++i) {
            BindingMessageReferenceImpl message = (BindingMessageReferenceImpl)messages[i];
            this.buildBindingMessageReferenceExtensions(message);
        }
    }

    private void buildBindingExtensions(BindingImpl binding) {
        this.fBindingType = binding.getType();
        if (this.fBindingType != null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$Binding == null ? (class$org$apache$woden$wsdl20$Binding = ComponentModelBuilder.class$("org.apache.woden.wsdl20.Binding")) : class$org$apache$woden$wsdl20$Binding, binding, this.fBindingType);
            binding.setComponentExtensionContext(this.fBindingType, compExt);
        }
    }

    private void buildBindingFaultExtensions(BindingFaultImpl bindFault) {
        if (this.fBindingType != null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$BindingFault == null ? (class$org$apache$woden$wsdl20$BindingFault = ComponentModelBuilder.class$("org.apache.woden.wsdl20.BindingFault")) : class$org$apache$woden$wsdl20$BindingFault, bindFault, this.fBindingType);
            bindFault.setComponentExtensionContext(this.fBindingType, compExt);
        }
    }

    private void buildBindingOperationExtensions(BindingOperationImpl bindOper) {
        if (this.fBindingType != null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$BindingOperation == null ? (class$org$apache$woden$wsdl20$BindingOperation = ComponentModelBuilder.class$("org.apache.woden.wsdl20.BindingOperation")) : class$org$apache$woden$wsdl20$BindingOperation, bindOper, this.fBindingType);
            bindOper.setComponentExtensionContext(this.fBindingType, compExt);
        }
    }

    private void buildBindingMessageReferenceExtensions(BindingMessageReferenceImpl bindMsgRef) {
        if (this.fBindingType != null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$BindingMessageReference == null ? (class$org$apache$woden$wsdl20$BindingMessageReference = ComponentModelBuilder.class$("org.apache.woden.wsdl20.BindingMessageReference")) : class$org$apache$woden$wsdl20$BindingMessageReference, bindMsgRef, this.fBindingType);
            bindMsgRef.setComponentExtensionContext(this.fBindingType, compExt);
        }
    }

    private void buildBindingFaultReferenceExtensions(BindingFaultReferenceImpl bindFaultRef) {
        if (this.fBindingType != null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$BindingFaultReference == null ? (class$org$apache$woden$wsdl20$BindingFaultReference = ComponentModelBuilder.class$("org.apache.woden.wsdl20.BindingFaultReference")) : class$org$apache$woden$wsdl20$BindingFaultReference, bindFaultRef, this.fBindingType);
            bindFaultRef.setComponentExtensionContext(this.fBindingType, compExt);
        }
    }

    private void buildServices(DescriptionImpl desc) {
        ServiceElement[] serviceEls = desc.getServiceElements();
        for (int i = 0; i < serviceEls.length; ++i) {
            ServiceImpl serviceImpl = (ServiceImpl)serviceEls[i];
            if (this.fServicesDone.contains(serviceImpl)) continue;
            this.buildEndpoints(serviceImpl);
            this.fServicesDone.add(serviceImpl);
        }
    }

    private void buildEndpoints(ServiceImpl serviceImpl) {
        EndpointElement[] endpoints = serviceImpl.getEndpointElements();
        for (int i = 0; i < endpoints.length; ++i) {
            EndpointImpl endpoint = (EndpointImpl)endpoints[i];
            this.buildEndpointExtensions(endpoint);
        }
    }

    private void buildEndpointExtensions(EndpointImpl endpoint) {
        if (this.fBindingType != null) {
            ComponentExtensionContext compExt = this.createComponentExtensions(class$org$apache$woden$wsdl20$Endpoint == null ? (class$org$apache$woden$wsdl20$Endpoint = ComponentModelBuilder.class$("org.apache.woden.wsdl20.Endpoint")) : class$org$apache$woden$wsdl20$Endpoint, endpoint, this.fBindingType);
            endpoint.setComponentExtensionContext(this.fBindingType, compExt);
        }
    }

    private ComponentExtensionContext createComponentExtensions(Class parentClass, WSDLComponent parentComp, URI extNS) {
        ExtensionRegistry er = this.fDesc.getWsdlContext().extensionRegistry;
        ComponentExtensionContext compExt = null;
        try {
            compExt = er.createComponentExtension(parentClass, parentComp, extNS);
        }
        catch (WSDLException e) {
            // empty catch block
        }
        return compExt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

