/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLStringLiteral;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTypedLiteral;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTranslator<NODE, RESOURCE extends NODE, PREDICATE extends NODE, LITERAL extends NODE>
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private OWLOntologyManager manager;
    private OWLOntology ontology;
    private boolean useStrongTyping = true;
    private Set<OWLAnonymousIndividual> processing = new HashSet<OWLAnonymousIndividual>();
    private Map<Object, NODE> nodeMap = new IdentityHashMap<Object, NODE>();

    public AbstractTranslator(OWLOntologyManager manager, OWLOntology ontology, boolean useStrongTyping) {
        this.ontology = ontology;
        this.manager = manager;
        this.useStrongTyping = useStrongTyping;
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getIRI(), axiom.getEntity().accept(OWLEntityTypeProvider.INSTANCE));
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.translateAnonymousNode(property);
        this.addTriple((OWLObject)property, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), property.getInverse());
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), node.getOperands());
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), node.getOperands());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples(node, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), node.getValues());
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ON_DATA_TYPE.getIRI(), node.getDatatype());
        this.addListTriples(node, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS.getIRI(), node.getFacetRestrictions());
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.translateAnonymousNode(desc);
        this.addListTriples(desc, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), desc.getOperands());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples(desc, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), desc.getOperands());
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), desc.getOperand());
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples(desc, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), desc.getIndividuals());
        this.processIfAnonymous(desc.getIndividuals(), null);
    }

    private void addRestrictionCommonTriples(OWLRestriction desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)desc.getProperty());
    }

    private void addCardinalityRestrictionTriples(OWLCardinalityRestriction ce, OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriples(ce);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        this.addRestrictionCommonTriples(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom desc) {
        this.addRestrictionCommonTriples(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
        this.addRestrictionCommonTriples(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), (OWLObject)desc.getValue());
        this.processIfAnonymous((OWLIndividual)desc.getValue(), null);
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        this.translateAnonymousNode(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)desc.getProperty());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), this.manager.getOWLDataFactory().getOWLTypedLiteral(true));
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        if (desc.isQualified()) {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        if (desc.isQualified()) {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        if (desc.isQualified()) {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLDataSomeValuesFrom desc) {
        this.addRestrictionCommonTriples(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLDataAllValuesFrom desc) {
        this.addRestrictionCommonTriples(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    @Override
    public void visit(OWLDataHasValue desc) {
        this.addRestrictionCommonTriples(desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), (OWLObject)desc.getValue());
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        if (desc.isQualified()) {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        if (desc.isQualified()) {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        if (desc.isQualified()) {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addCardinalityRestrictionTriples(desc, OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubClass(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), (OWLObject)axiom.getSuperClass());
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwiseClassExpressions(axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwiseClassExpressions(axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getClassExpressions());
            this.translateAnnotations(axiom);
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (RESOURCE)axiom.getOWLClass(), (PREDICATE)OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI(), (NODE)axiom.getClassExpressions());
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (RESOURCE)axiom.getSuperProperty(), (PREDICATE)OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI(), (NODE)axiom.getPropertyChain());
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.translateAnnotations(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getFirstProperty(), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)axiom.getSecondProperty());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise(axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode(axiom);
            this.translateAnnotations(axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples(axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getDatatype(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), (OWLObject)axiom.getDataRange());
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (RESOURCE)axiom.getClassExpression(), (PREDICATE)OWLRDFVocabulary.OWL_HAS_KEY.getIRI(), (NODE)axiom.getPropertyExpressions());
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.addPairwise(axiom, axiom.getIndividuals(), OWLRDFVocabulary.OWL_SAME_AS.getIRI());
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
        this.addListTriples(axiom, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getIRI(), axiom.getIndividuals());
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getIndividual(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (OWLObject)axiom.getClassExpression());
        this.processIfAnonymous(axiom.getIndividual(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyAssertionAxiom simplified = axiom.getSimplified();
        this.addSingleTripleAxiom((OWLAxiom)simplified, (OWLObject)simplified.getSubject(), (OWLObject)simplified.getProperty(), (OWLObject)simplified.getObject());
        this.processIfAnonymous((OWLIndividual)simplified.getObject(), (OWLAxiom)axiom);
        this.processIfAnonymous(simplified.getSubject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), (OWLObject)axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations(axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
        this.processIfAnonymous((OWLIndividual)axiom.getObject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode(axiom);
        for (OWLAnnotation anno : axiom.getAnnotations()) {
            this.addTriple((OWLObject)axiom, anno.getProperty().getIRI(), anno.getValue());
        }
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), (OWLObject)axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), (OWLObject)axiom.getObject());
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), axiom.getProperty(), (OWLObject)axiom.getValue());
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), axiom.getDomain());
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), axiom.getRange());
    }

    @Override
    public void visit(OWLClass desc) {
        if (!this.nodeMap.containsKey(desc)) {
            this.nodeMap.put(desc, this.getResourceNode(desc.getIRI()));
        }
        this.addStrongTyping(desc);
    }

    @Override
    public void visit(OWLDatatype node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put(node, this.getResourceNode(node.getIRI()));
        }
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, node.getFacet().getIRI(), node.getFacetValue());
    }

    @Override
    public void visit(IRI iri) {
        if (!this.nodeMap.containsKey(iri)) {
            this.nodeMap.put(iri, this.getResourceNode(iri));
        }
    }

    @Override
    public void visit(OWLTypedLiteral node) {
        this.nodeMap.put(node, this.getLiteralNode(node.getLiteral(), node.getDatatype().getIRI()));
    }

    @Override
    public void visit(OWLStringLiteral node) {
        this.nodeMap.put(node, this.getLiteralNode(node.getLiteral(), node.getLang()));
    }

    @Override
    public void visit(OWLDataProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put(property, this.getPredicateNode(property.getIRI()));
        }
        this.addStrongTyping(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put(property, this.getPredicateNode(property.getIRI()));
        }
        this.addStrongTyping(property);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put(property, this.getPredicateNode(property.getIRI()));
        }
        this.addStrongTyping(property);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        if (!this.nodeMap.containsKey(individual)) {
            this.nodeMap.put(individual, this.getResourceNode(individual.getIRI()));
        }
        this.addStrongTyping(individual);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.translateAnonymousNode(individual);
    }

    @Override
    public void visit(OWLOntology ontology) {
        if (ontology.isAnonymous()) {
            this.translateAnonymousNode(ontology);
        } else if (!this.nodeMap.containsKey(ontology)) {
            this.nodeMap.put(ontology, this.getResourceNode(ontology.getOntologyID().getOntologyIRI()));
        }
        this.addTriple((OWLObject)ontology, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
    }

    @Override
    public void visit(SWRLRule rule) {
        this.translateAnonymousNode(rule);
        this.addTriple((OWLObject)rule, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.IMP.getIRI());
        Set<SWRLAtom> antecedent = rule.getBody();
        this.addTriple(rule, SWRLVocabulary.BODY.getIRI(), antecedent, SWRLVocabulary.ATOM_LIST.getIRI());
        Set<SWRLAtom> consequent = rule.getHead();
        this.addTriple(rule, SWRLVocabulary.HEAD.getIRI(), consequent, SWRLVocabulary.ATOM_LIST.getIRI());
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.CLASS_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.CLASS_PREDICATE.getIRI(), node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.DATA_RANGE.getIRI(), node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept(this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        this.addTriple((OWLObject)node, SWRLVocabulary.BUILT_IN.getIRI(), node.getPredicate());
        this.addTriple(this.getResourceNode(node.getPredicate()), this.getPredicateNode(SWRLVocabulary.BUILT_IN_CLASS.getIRI()), this.getResourceNode(SWRLVocabulary.BUILT_IN_CLASS.getIRI()));
        this.addTriple(this.getResourceNode(node), this.getPredicateNode(SWRLVocabulary.ARGUMENTS.getIRI()), this.translateList(new ArrayList<SWRLDArgument>(node.getArguments())));
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.translateAnonymousNode(node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    @Override
    public void visit(SWRLVariable node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put(node, this.getResourceNode(node.getIRI()));
        }
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.VARIABLE.getIRI());
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
        this.nodeMap.put(node, this.nodeMap.get(node.getIndividual()));
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
        this.nodeMap.put(node, this.nodeMap.get(node.getLiteral()));
    }

    private void processAnonymousIndividual(OWLIndividual ind) {
        if (!ind.isAnonymous()) {
            return;
        }
        for (OWLIndividualAxiom ax : this.ontology.getAxioms(ind)) {
            ax.accept(this);
        }
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subject, IRI pred, OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subject, IRI pred, IRI obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subj, IRI pred, Collection<? extends OWLObject> obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(obj)));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subj, OWLObject pred, OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, RESOURCE subject, PREDICATE predicate, NODE object) {
        this.addTriple(subject, predicate, object);
        if (ax.getAnnotations().isEmpty()) {
            return;
        }
        this.translateAnonymousNode(ax);
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(OWLRDFVocabulary.OWL_AXIOM.getIRI()));
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI()), subject);
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI()), predicate);
        this.addTriple(this.getResourceNode(ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI()), object);
        this.translateAnnotations(ax);
    }

    private void translateAnnotations(OWLAxiom ax) {
        this.translateAnonymousNode(ax);
        for (OWLAnnotation anno : ax.getAnnotations()) {
            this.translateAnnotation(ax, anno);
        }
    }

    private void translateAnnotation(OWLObject subject, OWLAnnotation annotation) {
        this.addTriple(subject, annotation.getProperty().getIRI(), annotation.getValue());
        if (annotation.getAnnotations().isEmpty()) {
            return;
        }
        this.translateAnonymousNode(annotation);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI(), subject);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI(), annotation.getProperty().getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI(), annotation.getValue());
        for (OWLAnnotation anno : annotation.getAnnotations()) {
            this.translateAnnotation(annotation, anno);
        }
    }

    @Override
    public void visit(OWLAnnotation node) {
        throw new OWLRuntimeException("The translator should not be used directly on instances of OWLAnnotation because an annotation cannot be translated without a subject.");
    }

    private void translateAnonymousNode(OWLObject object) {
        this.nodeMap.put(object, this.getAnonymousNode(object));
    }

    protected abstract RESOURCE getResourceNode(IRI var1);

    protected abstract PREDICATE getPredicateNode(IRI var1);

    protected abstract RESOURCE getAnonymousNode(Object var1);

    protected abstract LITERAL getLiteralNode(String var1, IRI var2);

    protected abstract LITERAL getLiteralNode(String var1, String var2);

    protected abstract void addTriple(RESOURCE var1, PREDICATE var2, NODE var3);

    private RESOURCE getResourceNode(OWLObject object) {
        NODE r = this.nodeMap.get(object);
        if (r == null) {
            object.accept(this);
            r = this.nodeMap.get(object);
            if (r == null) {
                throw new IllegalStateException("Node is null!");
            }
        }
        return (RESOURCE)r;
    }

    private PREDICATE getPredicateNode(OWLObject object) {
        NODE p = this.nodeMap.get(object);
        if (p == null) {
            object.accept(this);
            p = this.nodeMap.get(object);
            if (p == null) {
                throw new IllegalStateException("Node is null!");
            }
        }
        return (PREDICATE)p;
    }

    private NODE getNode(OWLObject obj) {
        NODE node = this.nodeMap.get(obj);
        if (node == null) {
            obj.accept(this);
            node = this.nodeMap.get(obj);
            if (node == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + obj);
            }
        }
        return node;
    }

    private RESOURCE translateList(List<? extends OWLObject> list) {
        return this.translateList(list, OWLRDFVocabulary.RDF_LIST.getIRI());
    }

    private RESOURCE translateList(List<? extends OWLObject> list, IRI listType) {
        int listSize;
        if (list.isEmpty()) {
            return this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        }
        RESOURCE main = this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        for (int i = listSize = list.size() - 1; i >= 0; --i) {
            RESOURCE anonNode = this.getAnonymousNode(list.subList(i, listSize));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(listType));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_FIRST.getIRI()), this.getNode(list.get(i)));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_REST.getIRI()), main);
            main = anonNode;
        }
        return main;
    }

    private void addTriple(OWLObject subject, IRI pred, IRI object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(object));
    }

    private void addTriple(OWLObject subject, IRI pred, OWLObject object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(object));
    }

    private void addListTriples(OWLObject subject, IRI pred, Set<? extends OWLObject> objects) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects)));
    }

    private void addTriple(OWLObject subject, IRI pred, Set<? extends OWLObject> objects, IRI listType) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects), listType));
    }

    private OWLTypedLiteral toTypedConstant(int i) {
        return this.manager.getOWLDataFactory().getOWLTypedLiteral(Integer.toString(i), this.manager.getOWLDataFactory().getOWLDatatype(XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()));
    }

    private void processIfAnonymous(Set<OWLIndividual> inds, OWLAxiom root) {
        for (OWLIndividual ind : inds) {
            this.processIfAnonymous(ind, root);
        }
    }

    private void processIfAnonymous(OWLIndividual ind, OWLAxiom root) {
        if (ind.isAnonymous()) {
            for (OWLIndividualAxiom ax : this.ontology.getAxioms(ind)) {
                if (root != null && root.equals(ax)) continue;
                ax.accept(this);
            }
        }
    }

    private boolean isAnonymous(OWLObject object) {
        return !(object instanceof OWLEntity) && !(object instanceof IRI);
    }

    private void addPairwise(OWLAxiom axiom, Collection<? extends OWLObject> objects, IRI IRI2) {
        ArrayList<? extends OWLObject> objectList = new ArrayList<OWLObject>(objects);
        for (int i = 0; i < objectList.size(); ++i) {
            for (int j = i; j < objectList.size(); ++j) {
                if (i == j) continue;
                this.addSingleTripleAxiom(axiom, (OWLObject)objectList.get(i), IRI2, (OWLObject)objectList.get(j));
            }
        }
    }

    private void addPairwiseClassExpressions(OWLAxiom axiom, Set<OWLClassExpression> classExpressions, IRI IRI2) {
        ArrayList<OWLClassExpression> classExpressionList = new ArrayList<OWLClassExpression>(classExpressions);
        this.addPairwise(axiom, classExpressionList, IRI2);
    }

    private void addStrongTyping(OWLEntity entity) {
        if (!this.useStrongTyping) {
            return;
        }
        if (entity.isBuiltIn()) {
            return;
        }
        this.addTriple((OWLObject)entity, OWLRDFVocabulary.RDF_TYPE.getIRI(), entity.accept(OWLEntityTypeProvider.INSTANCE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OWLEntityTypeProvider
    implements OWLEntityVisitorEx<IRI> {
        public static OWLEntityTypeProvider INSTANCE = new OWLEntityTypeProvider();

        private OWLEntityTypeProvider() {
        }

        @Override
        public IRI visit(OWLClass cls) {
            return OWLRDFVocabulary.OWL_CLASS.getIRI();
        }

        @Override
        public IRI visit(OWLObjectProperty property) {
            return OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI();
        }

        @Override
        public IRI visit(OWLDataProperty property) {
            return OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI();
        }

        @Override
        public IRI visit(OWLNamedIndividual individual) {
            return OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI();
        }

        @Override
        public IRI visit(OWLDatatype datatype) {
            return OWLRDFVocabulary.RDFS_DATATYPE.getIRI();
        }

        @Override
        public IRI visit(OWLAnnotationProperty property) {
            return OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI();
        }
    }
}

