/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractDataRestrictionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class AbstractDataCardinalityTranslator
extends AbstractDataRestrictionTranslator {
    public AbstractDataCardinalityTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    protected abstract IRI getCardinalityTriplePredicate();

    protected abstract IRI getQualifiedCardinalityTriplePredicate();

    private int translateCardinality(IRI mainNode) {
        OWLLiteral cardiObject = this.getLiteralObject(mainNode, this.getCardinalityTriplePredicate(), true);
        if (cardiObject == null) {
            cardiObject = this.getLiteralObject(mainNode, this.getQualifiedCardinalityTriplePredicate(), true);
        }
        if (cardiObject == null) {
            return -1;
        }
        return Integer.parseInt(cardiObject.getLiteral());
    }

    private OWLDataRange translateFiller(IRI mainNode) {
        IRI onDataRangeObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), true);
        if (onDataRangeObject == null) {
            return this.getDataFactory().getTopDatatype();
        }
        return this.getConsumer().translateDataRange(onDataRangeObject);
    }

    protected OWLClassExpression translateRestriction(IRI mainNode) {
        int cardinality = this.translateCardinality(mainNode);
        if (cardinality < 0) {
            return this.getConsumer().getOWLClass(mainNode);
        }
        OWLDataPropertyExpression prop = this.translateOnProperty(mainNode);
        if (prop == null) {
            return this.getConsumer().getOWLClass(mainNode);
        }
        return this.createRestriction(prop, cardinality, this.translateFiller(mainNode));
    }

    protected abstract OWLClassExpression createRestriction(OWLDataPropertyExpression var1, int var2, OWLDataRange var3);
}

