/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPEquivalentPropertyHandler
extends TriplePredicateHandler {
    private static final Logger logger = Logger.getLogger(TPEquivalentPropertyHandler.class.getName());

    public TPEquivalentPropertyHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return this.getConsumer().isObjectPropertyOnly(subject) && this.getConsumer().isObjectPropertyOnly(object) || this.getConsumer().isDataPropertyOnly(subject) && this.getConsumer().isDataPropertyOnly(object);
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isObjectPropertyOnly(object)) {
            this.translateEquivalentObjectProperties(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject) || this.getConsumer().isDataPropertyOnly(object)) {
            HashSet<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
            props.add(this.translateDataProperty(subject));
            props.add(this.translateDataProperty(object));
            this.addAxiom(this.getDataFactory().getOWLEquivalentDataPropertiesAxiom(props, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else {
            this.translateEquivalentObjectProperties(subject, predicate, object);
            logger.fine("Assuming equivalent object properties because property types are ambiguous: " + subject + " <-> " + object);
        }
    }

    private void translateEquivalentObjectProperties(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        props.add(this.translateObjectProperty(subject));
        props.add(this.translateObjectProperty(object));
        this.addAxiom(this.getDataFactory().getOWLEquivalentObjectPropertiesAxiom(props, this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

