/*
 * Created on Apr 4, 2005
 *
 */
package edu.uga.cs.lsdis.meteors.wadls;

import java.util.*;

import javax.wadls.*;
import javax.xml.namespace.*;

import org.w3c.dom.*;

/**
 * This class represents an instance of PreCondition or Effect,
 *
 * @author Zixin Wu
 */
public class OperationAddOnImpl implements PreCondition, Effect
{
	protected String name = null;
	protected List<ModelReference> modelReferences = null;
	protected String expression = null;
	protected Element docEl = null;
	protected Map extensionAttributes = new HashMap();
	protected List nativeAttributeNames =
		Arrays.asList(Constants.OPADDON_ATTR_NAMES);
	
	public static final long serialVersionUID = 1;
	
	/**
	 * Set the name.
	 *
	 * @param name the desired name
	 */
	public void setName(String name)
	{
		this.name = name;
	}
	
	/**
	 * Get the name.
	 *
	 * @return the name
	 */
	public String getName()
	{
		return name;
	}
	
	/**
	 * Get the modelReference.
	 *
	 * @return The modelReference
	 */
	public ModelReference getModelReference(){
		if(modelReferences == null)
			return null;
		return modelReferences.get(0);
	}
	
	/**
	 * Set the modelReference.
	 *
	 * @param modelReference The desired modelReference.
	 */
	public void addModelReference(ModelReference modelReference){
		if(modelReferences == null)
			modelReferences = new ArrayList<ModelReference>();
		modelReferences.add(0, modelReference);
	}
	
	/**
	 * Set the expression.
	 *
	 * @param expression The desired expression.
	 */
	public void setExpression(String expression){
		this.expression = expression;
	}
	
	/**
	 * Get the expression.
	 *
	 * @return The expression.
	 */
	public String getExpression(){
		return this.expression;
	}
	
	/**
	 * Set the documentation element for this document. This dependency
	 * on org.w3c.dom.Element should eventually be removed when a more
	 * appropriate way of representing this information is employed.
	 *
	 * @param docEl the documentation element
	 */
	public void setDocumentationElement(Element docEl)
	{
		this.docEl = docEl;
	}
	
	/**
	 * Get the documentation element. This dependency on org.w3c.dom.Element
	 * should eventually be removed when a more appropriate way of
	 * representing this information is employed.
	 *
	 * @return the documentation element
	 */
	public Element getDocumentationElement()
	{
		return docEl;
	}
	
	/**
	 * Set an extension attribute on this element. Pass in a null value to remove
	 * an extension attribute.
	 *
	 * @param name the extension attribute name
	 * @param value the extension attribute value. Can be a String, a QName, a
	 * List of Strings, or a List of QNames.
	 *
	 * @see #getExtensionAttribute
	 * @see #getExtensionAttributes
	 * @see ExtensionRegistry#registerExtensionAttributeType
	 * @see ExtensionRegistry#queryExtensionAttributeType
	 */
	public void setExtensionAttribute(QName name, Object value)
	{
		if (value != null)
		{
			extensionAttributes.put(name, value);
		}
		else
		{
			extensionAttributes.remove(name);
		}
	}
	
	/**
	 * Retrieve an extension attribute from this element. If the extension
	 * attribute is not defined, null is returned.
	 *
	 * @param name the extension attribute name
	 *
	 * @return the value of the extension attribute, or null if
	 * it is not defined. Can be a String, a QName, a List of Strings, or a List
	 * of QNames.
	 *
	 * @see #setExtensionAttribute
	 * @see #getExtensionAttributes
	 * @see ExtensionRegistry#registerExtensionAttributeType
	 * @see ExtensionRegistry#queryExtensionAttributeType
	 */
	public Object getExtensionAttribute(QName name)
	{
		return extensionAttributes.get(name);
	}
	
	/**
	 * Get the map containing all the extension attributes defined
	 * on this element. The keys are the qnames of the attributes.
	 *
	 * @return a map containing all the extension attributes defined
	 * on this element
	 *
	 * @see #setExtensionAttribute
	 * @see #getExtensionAttribute
	 */
	public Map getExtensionAttributes()
	{
		return extensionAttributes;
	}
	
	/**
	 * Get the list of local attribute names defined for this element in
	 * the WSDLS specification.
	 *
	 * @return a List of Strings, one for each local attribute name
	 */
	public List getNativeAttributeNames()
	{
		return nativeAttributeNames;
	}
	
	public String toString()
	{
		StringBuffer strBuf = new StringBuffer();
		
		strBuf.append("name=" + name);
		
		strBuf.append("\nmodelReference=");
		for(ModelReference ref : modelReferences) {
			strBuf.append(ref.toString());
			strBuf.append('\n');
		}
		
		if (expression != null)
		{
			strBuf.append("\nexpression=" + expression);
		}
		
//		Iterator keys = extensionAttributes.keySet().iterator();
//		
//		while (keys.hasNext())
//		{
//		QName name = (QName)keys.next();
//		
//		strBuf.append("\nextension attribute: " + name + "=" +
//		extensionAttributes.get(name));
//		}
		
		return strBuf.toString();
	}
	
	public List<ModelReference> getModelReferences() {
		return modelReferences;
	}
	
	public void setModelReferences(List<ModelReference> refs) {
		modelReferences = refs;		
	}
}
