/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLHasKeyAxiomImpl
extends OWLAxiomImpl
implements OWLHasKeyAxiom {
    private OWLClassExpression expression;
    private Set<OWLPropertyExpression> propertyExpressions;

    public OWLHasKeyAxiomImpl(OWLDataFactory dataFactory, OWLClassExpression expression, Set<? extends OWLPropertyExpression> propertyExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory, annotations);
        this.expression = expression;
        this.propertyExpressions = Collections.unmodifiableSortedSet(new TreeSet<OWLPropertyExpression>(propertyExpressions));
    }

    @Override
    public OWLHasKeyAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return this.getOWLDataFactory().getOWLHasKeyAxiom(this.getClassExpression(), this.getPropertyExpressions());
    }

    @Override
    public OWLHasKeyAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return this.getOWLDataFactory().getOWLHasKeyAxiom(this.getClassExpression(), this.getPropertyExpressions(), this.mergeAnnos(annotations));
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.HAS_KEY;
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    @Override
    public OWLClassExpression getClassExpression() {
        return this.expression;
    }

    @Override
    public Set<OWLPropertyExpression> getPropertyExpressions() {
        return this.propertyExpressions;
    }

    @Override
    public Set<OWLDataPropertyExpression> getDataPropertyExpressions() {
        TreeSet<OWLDataPropertyExpression> props = new TreeSet<OWLDataPropertyExpression>();
        for (OWLPropertyExpression prop : this.propertyExpressions) {
            if (!prop.isDataPropertyExpression()) continue;
            props.add((OWLDataPropertyExpression)prop);
        }
        return props;
    }

    @Override
    public Set<OWLObjectPropertyExpression> getObjectPropertyExpressions() {
        TreeSet<OWLObjectPropertyExpression> props = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLPropertyExpression prop : this.propertyExpressions) {
            if (!prop.isObjectPropertyExpression()) continue;
            props.add((OWLObjectPropertyExpression)prop);
        }
        return props;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLHasKeyAxiom other = (OWLHasKeyAxiom)object;
        int diff = this.expression.compareTo(other.getClassExpression());
        if (diff != 0) {
            return diff;
        }
        return OWLHasKeyAxiomImpl.compareSets(this.propertyExpressions, other.getPropertyExpressions());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLHasKeyAxiom)) {
            return false;
        }
        OWLHasKeyAxiom other = (OWLHasKeyAxiom)obj;
        return this.expression.equals(other.getClassExpression()) && ((Object)this.propertyExpressions).equals(other.getPropertyExpressions()) && ((Object)other.getAnnotations()).equals(this.getAnnotations());
    }
}

