/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPImportsHandler
extends TriplePredicateHandler {
    private Set<IRI> schemaImportsIRIs = new HashSet<IRI>();

    public TPImportsHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        for (Namespaces n : Namespaces.values()) {
            String ns = n.toString();
            this.schemaImportsIRIs.add(IRI.create(ns.substring(0, ns.length() - 1)));
        }
        this.schemaImportsIRIs.add(IRI.create("http://www.daml.org/rules/proposal/swrlb.owlapi"));
        this.schemaImportsIRIs.add(IRI.create("http://www.daml.org/rules/proposal/swrl.owlapi"));
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return true;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        this.consumeTriple(subject, predicate, object);
        this.getConsumer().addOntology(subject);
        this.getConsumer().addOntology(object);
        if (!this.schemaImportsIRIs.contains(object)) {
            OWLOntologyFormat importedOntologyFormat;
            OWLImportsDeclaration importsDeclaration = this.getDataFactory().getOWLImportsDeclaration(object);
            this.getConsumer().addImport(importsDeclaration);
            OWLOntologyManager man = this.getConsumer().getOWLOntologyManager();
            man.makeLoadImportRequest(importsDeclaration);
            OWLOntology importedOntology = man.getImportedOntology(importsDeclaration);
            if (importedOntology != null && (importedOntologyFormat = man.getOntologyFormat(importedOntology)) instanceof RDFOntologyFormat && importedOntology.isAnonymous()) {
                man.applyChange(new RemoveImport(this.getConsumer().getOntology(), importsDeclaration));
                for (OWLImportsDeclaration decl : importedOntology.getImportsDeclarations()) {
                    man.applyChange(new AddImport(this.getConsumer().getOntology(), decl));
                }
                for (OWLAnnotation anno : importedOntology.getAnnotations()) {
                    man.applyChange(new AddOntologyAnnotation(this.getConsumer().getOntology(), anno));
                }
                for (OWLAxiom ax : importedOntology.getAxioms()) {
                    this.getConsumer().addAxiom(ax);
                }
                man.removeOntology(importedOntology);
            }
            this.getConsumer().importsClosureChanged();
        }
    }
}

