/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.AbstractClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OneOfTranslator
extends AbstractClassExpressionTranslator {
    Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());

    public OneOfTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    public OWLClassExpression translate(IRI mainNode) {
        IRI oneOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), true);
        Set<OWLIndividual> individuals = this.translateToIndividualSet(oneOfObject);
        for (OWLIndividual ind : individuals) {
            if (ind.isAnonymous()) continue;
            this.getConsumer().addIndividual(((OWLNamedIndividual)ind).getIRI());
        }
        if (individuals.isEmpty()) {
            this.logger.info("Empty set in owl:oneOf class expression - converting to owl:Nothing");
            return this.getDataFactory().getOWLNothing();
        }
        return this.getDataFactory().getOWLObjectOneOf(individuals);
    }
}

