/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.bhig.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.coode.xml.XMLWriter;
import org.coode.xml.XMLWriterImpl;
import org.coode.xml.XMLWriterNamespaceManager;
import uk.ac.manchester.cs.bhig.util.MutableTree;
import uk.ac.manchester.cs.bhig.util.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmniGraffleWriter<N> {
    private Tree<N> tree;
    private static final String PLIST_ELEMENT_NAME = "plist";
    private static final String DICT_ELEMENT_NAME = "dict";
    private static final String KEY_ELEMENT_NAME = "key";
    private static final String GRAPHICS_LIST = "GraphicsList";
    private static final String ARRAY = "array";
    private Map<Object, Integer> nodeIDMap = new IdentityHashMap<Object, Integer>();
    private Map<LineHolder, Integer> lineIDMap = new HashMap<LineHolder, Integer>();
    private int counter = 0;
    private static int depth = 10;

    public OmniGraffleWriter(Tree<N> tree) {
        this.tree = tree;
    }

    public void write(Writer writer) throws IOException {
        XMLWriterNamespaceManager nsm = new XMLWriterNamespaceManager("");
        XMLWriterImpl xmlWriter = new XMLWriterImpl(writer, nsm);
        xmlWriter.writeStartElement(PLIST_ELEMENT_NAME);
        xmlWriter.writeStartElement(DICT_ELEMENT_NAME);
        xmlWriter.writeStartElement(KEY_ELEMENT_NAME);
        xmlWriter.writeTextContent(GRAPHICS_LIST);
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(ARRAY);
        this.writeTreeElement(this.tree, xmlWriter);
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
    }

    private void writeTreeElement(Tree<N> tree, XMLWriter writer) throws IOException {
        this.writeKeyValue(null, this.getNodeValuesMap(tree), writer);
        for (Tree<N> child : tree.getChildren()) {
            this.writeTreeElement(child, writer);
            this.writeKeyValue(null, this.getLineValuesMap(tree, child), writer);
        }
    }

    private Map<String, Object> getNodeValuesMap(Tree tree) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Bounds", "{{10, 10}, {10, 10}}");
        map.put("Class", "ShapedGraphic");
        map.put("FitText", "YES");
        map.put("Flow", "Resize");
        map.put("ID", this.getID(tree));
        map.put("Shape", "Rectangle");
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("Text", tree.getUserObject().toString());
        map.put("Text", textMap);
        map.put("Wrap", "NO");
        return map;
    }

    private Map<String, Object> getLineLabelValuesMap(Tree parent, Tree child) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Bounds", "{{10, 10}, {10, 10}}");
        map.put("Class", "ShapedGraphic");
        map.put("FitText", "YES");
        map.put("ID", this.getID(this.tree.getUserObject()));
        HashMap<String, Object> lineMap = new HashMap<String, Object>();
        lineMap.put("ID", this.getLineID(parent, child));
        lineMap.put("Position", 0.5);
        lineMap.put("RotationType", "0");
        map.put("Shape", "Rectangle");
        map.put("Line", lineMap);
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("Text", parent.getEdge(child).toString());
        map.put("Text", textMap);
        map.put("Wrap", "NO");
        return map;
    }

    private Map<String, Object> getLineValuesMap(Tree parent, Tree child) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Class", "LineGraphic");
        map.put("ID", this.getLineID(parent, child));
        HashMap<String, Integer> headMap = new HashMap<String, Integer>();
        headMap.put("ID", this.getID(child));
        map.put("Head", headMap);
        HashMap<String, Integer> tailMap = new HashMap<String, Integer>();
        tailMap.put("ID", this.getID(parent));
        map.put("Tail", tailMap);
        return map;
    }

    private int getID(Object obj) {
        Integer id = this.nodeIDMap.get(obj);
        if (id == null) {
            id = this.counter;
            ++this.counter;
            this.nodeIDMap.put(obj, id);
        }
        return id;
    }

    private int getLineID(Tree parent, Tree child) {
        LineHolder holder = new LineHolder(parent, child);
        Integer id = this.lineIDMap.get(holder);
        if (id == null) {
            id = this.counter;
            ++this.counter;
            this.lineIDMap.put(holder, id);
        }
        return id;
    }

    private void writeKeyValue(String key, Object value, XMLWriter writer) throws IOException {
        if (key != null) {
            writer.writeStartElement(KEY_ELEMENT_NAME);
            writer.writeTextContent(key);
            writer.writeEndElement();
        }
        if (value instanceof String) {
            writer.writeStartElement("string");
            writer.writeTextContent(value.toString());
            writer.writeEndElement();
        } else if (value instanceof Integer) {
            writer.writeStartElement("integer");
            writer.writeTextContent(value.toString());
            writer.writeEndElement();
        } else if (value instanceof Float || value instanceof Double) {
            writer.writeStartElement("real");
            writer.writeTextContent(value.toString());
            writer.writeEndElement();
        } else if (value instanceof Map) {
            Map values = (Map)value;
            writer.writeStartElement(DICT_ELEMENT_NAME);
            for (String k : values.keySet()) {
                this.writeKeyValue(k, values.get(k), writer);
            }
            writer.writeEndElement();
        }
    }

    public static void main(String[] args) {
        try {
            MutableTree<String> root = new MutableTree<String>("Root");
            OmniGraffleWriter.constructDummy(root, 0);
            OmniGraffleWriter<String> writer = new OmniGraffleWriter<String>(root);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream("/tmp/test2.graffle"));
            writer.write(outputStreamWriter);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void constructDummy(MutableTree tree, int curDepth) {
        ++curDepth;
        for (int i = 0; i < 3; ++i) {
            MutableTree<String> child0 = new MutableTree<String>("Child" + i);
            tree.addChild(child0, "Edge" + i);
            if (curDepth >= depth) continue;
            OmniGraffleWriter.constructDummy(child0, curDepth);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineHolder<N> {
        private Tree<N> parent;
        private Tree<N> child;

        private LineHolder(Tree<N> parent, Tree<N> child) {
            this.parent = parent;
            this.child = child;
        }

        public int hashCode() {
            return this.parent.hashCode() * 37 + this.child.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LineHolder)) {
                return false;
            }
            LineHolder other = (LineHolder)obj;
            return other.parent.equals(this.parent) && other.child.equals(this.child);
        }
    }
}

