/*
 * (c) Copyright IBM Corp 2004, 2005 
 */

package edu.uga.cs.lsdis.meteors.wadls.extensions.schema;

import java.io.PrintWriter;
import java.io.Serializable;

import javax.wadls.Application;
import javax.wadls.WADLSException;
import javax.wadls.extensions.ExtensionDeserializer;
import javax.wadls.extensions.schema.Schema;
import javax.wadls.extensions.ExtensionSerializer;
import javax.wadls.WADLSException;
import javax.wadls.extensions.ExtensibilityElement;
import javax.wadls.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;

import edu.uga.cs.lsdis.meteors.wadls.util.xml.DOM2Writer;

/**
 * This class is used to serialize Schema instances
 * into the PrintWriter.
 *
 * @see SchemaImpl
 * @see SchemaDeserializer
 *
 * @author Jeremy Hughes <hughesj@uk.ibm.com>
 */
public class SchemaSerializer implements ExtensionSerializer,Serializable
{
  public static final long serialVersionUID = 1;
  public void marshall(Class parentType,
          QName elementType,
          ExtensibilityElement extension,
          PrintWriter pw,
          Application def,
          ExtensionRegistry extReg)
            throws WADLSException
{
Schema schema = (Schema)extension;

pw.print("    ");

DOM2Writer.serializeAsXML(schema.getElement(), pw);

pw.println();
}
}