import warnings
import platform
import os,sys
from generateClient import *
from generateClient1 import *

'''input : wadl/wsdl/sawadl-url, method name
purpose: 
1. Calls methods from generateClient1.py to generate client description for one-time invocation
of the Web service. This client description is added as a xml file under ./clients/
2. Calls methods from generateClient.py to generate client description for invocation of Web service
in a workflow. This client description is added as a xml file under ./workflowclients/
3. Adds the path to the above xml files to Galaxy tool-conf.xml file using call edit_tool_conf.py
'''

#read the url passed as an argument
url = sys.argv[2]

#split url passed on '.' character
urllist = url.split('.')

clientGenerator = ClientGenerator(sys.argv[2],sys.argv[3],sys.argv[4],sys.argv[5])
clientGenerator1 = ClientGenerator1(sys.argv[2],sys.argv[3],sys.argv[4],sys.argv[5])

#if url passed is of a WADL document
if urllist[len(urllist)-1]=='wadl' or urllist[len(urllist)-1]=='WADL':
    javahome = os.environ.get('JAVA_HOME')
    galaxyhome=os.environ.get('GALAXY_HOME')
    classpath= galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/bin'
    jarpath = galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/lib/'
    machine = platform.machine()

#start JVM depending on the machine. The location of libjvm.so is assumed to be standard.
#you can replace lines 32 to 41, with startJVM("LOCATION OF YOUR LIBJVM.SO","-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)       
    if machine == 'x86_64' :
        print 'a'
        startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    elif machine == 'i686' :
        print 'b'
        startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    elif machine == 'sun4u' :
        startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    else :
        System.exit("Could not identify machine, please specify path to libjvm.so")

#generate client xml for one time invocation of a Web service      
    clientGenerator1.wadlClient()

#generate client xml for invocation of a Web service in workflows         
    clientGenerator.wadlClient()

#if url passed is of a WSDL 2.0 document
elif urllist[len(urllist)-1]=='wsdl' or urllist[len(urllist)-1]=='WSDL':
    clientGenerator.wsdlClient()
    clientGenerator1.wsdlClient()    

#if url passed is of a SAWADL document
elif urllist[len(urllist)-1]=='sawadl' or urllist[len(urllist)-1]=='SAWADL':

    javahome = os.environ.get('JAVA_HOME')
    galaxyhome=os.environ.get('GALAXY_HOME')
    classpath= galaxyhome + '/tools/WebServiceToolWorkflow/lib/SAWADLParser/bin'
    jarpath = galaxyhome + '/tools/WebServiceToolWorkflow/lib/'
    machine = platform.machine()
    
    if machine == 'x86_64' :
        print 'a'
        startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    elif machine == 'i686' :
        print 'b'
        startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    elif machine == 'sun4u' :
        startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
    else :
        print 'c'
        System.exit("Could not identify machine, please specify path to libjvm.so")    
    
    #f=open(sys.argv[5],'w')
    #f.write('reached here 2 \t')
    #f.close()
    
    clientGenerator.sawadlClient()
    clientGenerator1.sawadlClient()    
    #f=open(sys.argv[5],'w')
    #f.write('reached here 3')
    #f.close()
    
    shutdownJVM()






