/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class StreamDocumentSource
implements OWLOntologyDocumentSource {
    public static final String DOCUMENT_IRI_SCHEME = "inputstream";
    private static int counter = 0;
    private IRI documentIRI;
    private byte[] buffer;

    public StreamDocumentSource(InputStream is) {
        this(is, StreamDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("inputstream:ontology" + ++counter);
    }

    public StreamDocumentSource(InputStream stream, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(InputStream stream) {
        try {
            int read;
            byte[] tempBuffer = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((read = stream.read(tempBuffer)) != -1) {
                bos.write(tempBuffer, 0, read);
            }
            this.buffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    public boolean isInputStreamAvailable() {
        return true;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buffer);
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public Reader getReader() {
        throw new OWLRuntimeException("Reader not available.  Check with StreamDocumentSource.isReaderAvailable() first!");
    }

    public boolean isReaderAvailable() {
        return false;
    }
}

