/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.net.URI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.IRIShortFormProvider;

public class OntologyIRIShortFormProvider
implements IRIShortFormProvider {
    public String getShortForm(OWLOntology ont) {
        if (!ont.isAnonymous()) {
            return this.getShortForm(ont.getOntologyID().getOntologyIRI());
        }
        return ont.getOntologyID().toString();
    }

    public String getShortForm(IRI iri) {
        String shortForm = iri.toString();
        URI uri = iri.toURI();
        String path = uri.getPath();
        if (path != null && path.length() > 0) {
            int lastSepIndex = path.lastIndexOf(47);
            String lastPathComponent = path.substring(lastSepIndex + 1, path.length());
            shortForm = lastPathComponent.endsWith(".owlapi") ? lastPathComponent.substring(0, lastPathComponent.length() - 4) : lastPathComponent;
        } else if (uri.getHost() != null) {
            shortForm = iri.toString();
        }
        return shortForm;
    }
}

