/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.List;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPSubPropertyOfHandler
extends TriplePredicateHandler {
    public TPSubPropertyOfHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (!this.getConsumer().isStrict() && this.getConsumer().hasPredicate(subject, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getIRI())) {
            IRI chainList = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getIRI(), true);
            List<OWLObjectPropertyExpression> properties = this.getConsumer().translateToObjectPropertyList(chainList);
            this.addAxiom(this.getDataFactory().getOWLSubPropertyChainOfAxiom(properties, this.translateObjectProperty(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (!this.getConsumer().isStrict() && this.getConsumer().isList(subject, false)) {
            List<OWLObjectPropertyExpression> properties = this.getConsumer().translateToObjectPropertyList(subject);
            this.addAxiom(this.getDataFactory().getOWLSubPropertyChainOfAxiom(properties, this.translateObjectProperty(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isObjectPropertyOnly(object)) {
            this.translateSubObjectProperty(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject) && this.getConsumer().isDataPropertyOnly(object)) {
            this.translateSubDataProperty(subject, predicate, object);
        } else if (!this.getConsumer().isStrict() && this.getConsumer().isAnnotationProperty(subject)) {
            OWLAnnotationProperty subAnnoProp = this.getDataFactory().getOWLAnnotationProperty(subject);
            OWLAnnotationProperty superAnnoProp = this.getDataFactory().getOWLAnnotationProperty(object);
            this.addAxiom(this.getDataFactory().getOWLSubAnnotationPropertyOfAxiom(subAnnoProp, superAnnoProp, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else {
            IRI subPropRange = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDFS_RANGE.getIRI(), false);
            if (subPropRange != null) {
                if (this.getConsumer().isDataRange(subPropRange)) {
                    this.translateSubDataProperty(subject, predicate, object);
                } else {
                    this.translateSubObjectProperty(subject, predicate, object);
                }
                return;
            }
            IRI supPropRange = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDFS_RANGE.getIRI(), false);
            if (supPropRange != null) {
                if (this.getConsumer().isDataRange(supPropRange)) {
                    this.translateSubDataProperty(subject, predicate, object);
                } else {
                    this.translateSubObjectProperty(subject, predicate, object);
                }
                return;
            }
            this.translateSubObjectProperty(subject, predicate, object);
        }
    }

    private void translateSubObjectProperty(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLSubObjectPropertyOfAxiom(this.translateObjectProperty(subject), this.translateObjectProperty(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateSubDataProperty(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLSubDataPropertyOfAxiom(this.translateDataProperty(subject), this.translateDataProperty(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

