package org.semanticweb.owlapi.util;
/*
 * Copyright (C) 2008, University of Manchester
 *
 * Modifications to the initial code base are copyright of their
 * respective authors, or their employers as appropriate.  Authorship
 * of the modifications may be determined from the ChangeLog placed at
 * the end of this file.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * Author: Matthew Horridge<br>
 * The University Of Manchester<br>
 * Information Management Group<br>
 * Date: 16-Jun-2008<br><br>
 *
 * A place holder for the current release number.
 */
public class VersionInfo {

    private static VersionInfo instance;

    private String version;

    private VersionInfo() {
        String v = VersionInfo.class.getPackage().getImplementationVersion();
        if(v != null) {
            version = v;
        }
        else {
            version = "[Not Released]";
        }
    }

    public synchronized static VersionInfo getVersionInfo() {
        if(instance == null) {
            instance = new VersionInfo();
        }
        return instance;
    }


    /**
     * Gets a string that contains the version of this build.  This
     * is generated from the manifest of the jar that this class is
     * packaged in.
     * @return The version info string (if available).
     */
    public String getVersion() {
        return version;
    }


    /**
     * Gets a message saying "Generated by the OWL API (version x.x.x)"
     * @return The message.
     */
    public String getGeneratedByMessage() {
        return "Generated by the OWL API (version " + version + ") http://owlapi.sourceforge.net";
    }

    public String toString() {
        return "The OWL API (version " + version + ")";
    }
}
