/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package edu.uga.cs.lsdis.meteors.wadls;

import javax.xml.namespace.*;

/**
 * This class contains the constatns of WSDLS
 * @author Zixin Wu (wuzixin@uga.edu)
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public class Constants
{
  // Namespace URIs.
  public static final String NS_URI_WADL =
    "http://wadl.dev.java.net/2009/02";
 
  public static final String NS_URI_WADLS =
  	"http://lsdis.cs.uga.edu/projects/meteor-s/wadl-s/examples/WSSemantics.xsd";
  public static final String NS_URI_SAWADL =
	  "http://www.w3.org/2002/ws/sawadl/spec/sawadl#";
  public static final String NS_URI_XMLNS =
    "http://www.w3.org/2000/xmlns/";

  //Prefix
  public static final String PREFIX_WSDLS =
  	"wssem";
  
  // Top-level element names.
  public static final String ELEM_DEFINITIONS = "application";
  public static final String ELEM_GRAMMARS = "grammars";
  public static final String ELEM_PARAM = "param";
  public static final String ELEM_TYPES = "types";
  public static final String ELEM_RESOURCE = "resource";
  // Non top-level element names.
  public static final String ELEM_OPERATION = "method";
  public static final String ELEM_PRECON = "precondition";
  public static final String ELEM_EFFECT = "effect";
  public static final String ELEM_INPUT = "request";
  public static final String ELEM_OUTPUT = "response";
  public static final String ELEM_HREF = "href";
  public static final String ELEM_RESOURCES = "resources";
  public static final String ELEM_INCLUDE = "include";
  public static final String ELEM_IMPORT = "import";
  public static final String ELEM_DOCUMENTATION = "doc";
  public static final String ELEM_REPRESENTATION = "representation";


  // Top-level qualified element names.
  public static final QName Q_ELEM_DEFINITIONS =
    new QName(NS_URI_WADL, ELEM_DEFINITIONS);
  public static final QName Q_ELEM_TYPES =
    new QName(NS_URI_WADL, ELEM_TYPES);
  public static final QName Q_ELEM_GRAMMARS =
	    new QName(NS_URI_WADL, ELEM_GRAMMARS);
  public static final QName Q_ELEM_PARAM =
	    new QName(NS_URI_WADL, ELEM_PARAM);
  public static final QName Q_ELEM_RESOURCE =
    new QName(NS_URI_WADL, ELEM_RESOURCE);
  public static final QName Q_ELEM_RESOURCES =
	    new QName(NS_URI_WADL, ELEM_RESOURCES);

  // Non top-level qualified element names.
  public static final QName Q_ELEM_OPERATION =
    new QName(NS_URI_WADL, ELEM_OPERATION);
  public static QName Q_ELEM_PRECON;
  public static QName Q_ELEM_EFFECT;
  public static QName Q_ELEM_CATEGORY;
  public static final QName Q_ELEM_INPUT =
    new QName(NS_URI_WADL, ELEM_INPUT);
  public static final QName Q_ELEM_OUTPUT =
    new QName(NS_URI_WADL, ELEM_OUTPUT);
  public static final QName Q_ELEM_DOCUMENTATION =
    new QName(NS_URI_WADL, ELEM_DOCUMENTATION);
  public static final QName Q_ELEM_REPRESENTATION =
	    new QName(NS_URI_WADL, ELEM_REPRESENTATION);
  public static final QName Q_ELEM_INCLUDE =
	    new QName(NS_URI_WADL, ELEM_INCLUDE);

  // Attribute names.
  public static final String ATTR_NAME = "name";
  public static final String PARAM_STYLE = "style";
  public static final String PARAM_NAME = "name";
  public static final String PARAM_TYPE = "type";
  public static final String PARAM_REQUIRED = "required";
  public static final String PARAM_DEFAULT = "default";
  public static final String OPTION_VALUE = "value";
  public static final String ATTR_BASE = "base";
  public static final String REQUEST_ELEMENT_NAME ="element";
  public static final String ATTR_PRE = "precondition";
  public static final String ID_NAME = "id";
  public static final String RESOURCE_ATTR_NAME = "path";
  public static final String ATTR_TARGET_NAMESPACE = "targetNamespace";
  public static final String ATTR_ELEMENT = "element";
  public static final String ATTR_TYPE = "type";
  public static final String ATTR_MESSAGE = "message";
  public static final String ATTR_MODELREF = "modelReference";
  public static final String ATTR_LIFTINGSCHEMAMAPPING = "liftingSchemaMapping";
  public static final String ATTR_LOWERINGSCHEMAMAPPING = "loweringSchemaMapping";
  public static final String ATTR_PARAMETER_ORDER = "parameterOrder";
  public static final String ATTR_EXPRESSION = "expression";
  public static final String ATTR_BINDING = "binding";
  public static final String ATTR_XMLNS = "xmlns";
  public static final String ATTR_NAMESPACE = "namespace";
  public static final String ATTR_LOCATION = "location";
  public static final String ATTR_REQUIRED = "required";
  public static final String ATTR_TAXONOMYURI = "taxonomyURI";
  public static final String ATTR_TAXONOMYCODE = "taxonomyCode";

  // Lists of native attribute names.
  public static final String[] PART_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_TYPE, ATTR_ELEMENT, ATTR_MODELREF};
  public static final String[] BINDING_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_TYPE};
  public static final String[] BINDING_FAULT_ATTR_NAMES =
    new String[]{ATTR_NAME};
  public static final String[] BINDING_INPUT_ATTR_NAMES =
    new String[]{ATTR_NAME};
  public static final String[] BINDING_OPERATION_ATTR_NAMES =
    new String[]{ATTR_NAME};
  public static final String[] BINDING_OUTPUT_ATTR_NAMES =
    new String[]{ATTR_NAME};
  public static final String[] FAULT_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_MESSAGE};
  public static final String[] IMPORT_ATTR_NAMES =
    new String[]{ATTR_NAMESPACE, ATTR_LOCATION};
  public static final String[] INPUT_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_MESSAGE};
  public static final String[] CATEGORY_ATTR_NAMES =
	    new String[]{ATTR_NAME, ATTR_TAXONOMYURI, ATTR_TAXONOMYCODE};
  public static final String[] OPADDON_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_EXPRESSION};
  public static final String[] MESSAGE_ATTR_NAMES =
    new String[]{ATTR_NAME};
  public static final String[] OPERATION_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_PARAMETER_ORDER};
  public static final String[] OUTPUT_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_MESSAGE};
  public static final String[] PORT_ATTR_NAMES =
    new String[]{ATTR_NAME, ATTR_BINDING};
  public static final String[] PORT_TYPE_ATTR_NAMES =
    new String[]{RESOURCE_ATTR_NAME};
  public static final String[] SERVICE_ATTR_NAMES =
    new String[]{ATTR_NAME};
  public static final String[] TYPES_ATTR_NAMES =
    new String[]{};

  // Qualified attribute names.
  public static final QName Q_ATTR_REQUIRED =
    new QName(NS_URI_WADL, ATTR_REQUIRED);
  public static QName Q_ATTR_MODELREF;
  public static QName Q_ATTR_LIFTINGSCHEMAMAPPING;
  public static QName Q_ATTR_LOWERINGSCHEMAMAPPING;

  // XML Declaration string.
  public static final String XML_DECL_DEFAULT = "UTF-8";
  public static final String XML_DECL_START =
    "<?xml version=\"1.0\" encoding=\"";
  public static final String XML_DECL_END = "\"?>";

  // Feature names.
  public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
  public static final String FEATURE_IMPORT_DOCUMENTS =
    "javax.wsdl.importDocuments";
  public static final String FEATURE_PARSE_SAWSDL = "urn:w3.org:sawsdl";
  public static final String FEATURE_PARSE_SAWADL = "urn:w3.org:sawadl";
  
  public static enum SemanticExtensionType {
	  WADLS, SAWADL;
  }
  
  public static final void setSemanticExtensionURI(SemanticExtensionType type) {
	  String uri = NS_URI_WADLS;
	  if(type == SemanticExtensionType.SAWADL)
		  uri = NS_URI_SAWADL;
		  
	  Q_ELEM_PRECON =
		  new QName(uri, ELEM_PRECON);
	  Q_ELEM_EFFECT =
		  new QName(uri, ELEM_EFFECT);
	  Q_ATTR_MODELREF =
		  new QName(uri, ATTR_MODELREF);
	  Q_ATTR_LIFTINGSCHEMAMAPPING =
		  new QName(uri, ATTR_LIFTINGSCHEMAMAPPING);
	  Q_ATTR_LOWERINGSCHEMAMAPPING =
		  new QName(uri, ATTR_LOWERINGSCHEMAMAPPING);
  }

}
