#!/usr/bin/env python

import argparse
import os

parser = argparse.ArgumentParser(description='Call bamtobed with parameters')
parser.add_argument('-i', '--inputBAM', required=True, help='input BAM file')
parser.add_argument('-o', '--outputBED', required=True, help='output BED file')
parser.add_argument('-oot', '--otherOutputType', required=True, help='Y or N')
parser.add_argument('-f', '--outputFormat', required=False, help='output file format')
parser.add_argument('-sc', '--scoreCalculation', required=True, help='calculation for BED score')
parser.add_argument('-tag', '--tag', required=False, help='another tag')
parser.add_argument('-spt', '--splitD', required=False, help='split : with “N” CIGAR and “D” operation', action="store_true")
parser.add_argument('-cgr', '--cigar', required=False, help='cigar string', action="store_true")

args = parser.parse_args()

# Displays the other output format if selected.
if args.otherOutputType == "Y":
	print('format output chosen : ' + args.outputFormat)

# Construction of the command line calling the tool. 
myCommandLine = ('bedtools bamtobed'+' -i ' + args.inputBAM)

# Other output format options.
if args.otherOutputType == "Y":
	if args.outputFormat == "BEDPE":
		myCommandLine += (' -bedpe ')
	elif args.outputFormat == "BED12":
		myCommandLine += (' -bed12 ')

# Score calculation options.
if args.scoreCalculation == "ed":
	myCommandLine += (' -ed ')
elif args.scoreCalculation == "tag":
	myCommandLine += (' -tag ' + args.tag)

# Split option.
if args.splitD:
	myCommandLine += (' -splitD ')
	print('Splitted BAM')

# CIGAR option.
if args.cigar:
	myCommandLine += (' -cigar ')
	print('CIGAR string column added')

myCommandLine += (' > ' + args.outputBED)

# Running of the command line.
os.system(myCommandLine)




