/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.classifiers.utils.PValueComputation;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.results.NumericalResult;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class SignificantMotifOccurrencesFinder {
    private RandomSeqType type;
    private boolean oneHistogram;
    private DataSet bg;
    private double[] weights;
    private MotifDiscoverer disc;
    private int numSequences;
    private double sign;
    private double[][] sortedScores;
    private int[][][] globalToLocalIndexes;
    private JoinMethod joinMethod;

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, RandomSeqType type, boolean oneHistogram, int numSequences, double sign) {
        this(disc, type, new SumOfProbabilities(), oneHistogram, numSequences, sign);
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, RandomSeqType type, JoinMethod joiner, boolean oneHistogram, int numSequences, double sign) {
        this.disc = disc;
        if (type == RandomSeqType.BACKGROUND) {
            throw new IllegalArgumentException("This type can not be used in this constructor.");
        }
        this.type = type;
        this.joinMethod = joiner;
        this.oneHistogram = oneHistogram;
        this.numSequences = numSequences;
        this.sign = sign;
        this.prepareIndices();
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, DataSet bg, double[] weights, double sign) {
        this(disc, new SumOfProbabilities(), bg, weights, sign);
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, JoinMethod joiner, DataSet bg, double[] weights, double sign) {
        this.disc = disc;
        this.type = RandomSeqType.BACKGROUND;
        this.joinMethod = joiner;
        this.oneHistogram = true;
        this.numSequences = bg.getNumberOfElements();
        this.bg = bg;
        this.weights = weights == null ? null : (double[])weights.clone();
        this.sign = sign;
        this.prepareIndices();
    }

    private void createBgDataSet(DataSet s) throws Exception {
        switch (this.type) {
            case BACKGROUND: {
                break;
            }
            case PERMUTED: {
                Sequence[] seqs = new Sequence[s.getNumberOfElements() * this.numSequences];
                int n = 0;
                int i = 0;
                while (i < s.getNumberOfElements()) {
                    Sequence current = s.getElementAt(i);
                    int j = 0;
                    while (j < this.numSequences) {
                        seqs[n] = new PermutedSequence(current);
                        ++j;
                        ++n;
                    }
                    ++i;
                }
                this.bg = new DataSet("permuted " + s.getAnnotation(), seqs);
                break;
            }
            case hMM0: 
            case hMM1: 
            case hMM2: 
            case hMM3: 
            case hMM4: 
            case hMM5: {
                int order = this.type.getOrder();
                HomogeneousMMDiffSM hmm = new HomogeneousMMDiffSM(s.getAlphabetContainer(), order, 0.0, new double[order + 1], true, true, 1);
                hmm.initializeFunction(0, false, new DataSet[]{s}, null);
                if (order > 0) {
                    double[][][] condProbs = hmm.getAllConditionalStationaryDistributions();
                    DoubleList list = new DoubleList((int)(1.5 * Math.pow(s.getAlphabetContainer().getAlphabetLengthAt(0), condProbs.length)));
                    int i = 0;
                    while (i < condProbs.length) {
                        int j = 0;
                        while (j < condProbs[i].length) {
                            int k = 0;
                            while (k < condProbs[i][j].length) {
                                list.add(Math.log(condProbs[i][j][k]));
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    hmm.setParameters(list.toArray(), 0);
                }
                this.bg = hmm.emit(this.numSequences * s.getNumberOfElements(), s.getElementLength());
            }
        }
    }

    private void createBgDataSet(Sequence seq) throws Exception {
        this.createBgDataSet(new DataSet("", seq));
    }

    private double[][] getAllProfilesOfScoresFor(int motif, Sequence seq, int start) throws Exception {
        double[][] profiles = new double[this.globalToLocalIndexes[motif][0].length][];
        int i = 0;
        while (i < this.globalToLocalIndexes[motif][0].length) {
            profiles[i] = this.disc.getProfileOfScoresFor(this.globalToLocalIndexes[motif][0][i], this.globalToLocalIndexes[motif][1][i], seq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
            ++i;
        }
        return profiles;
    }

    private double[] getJointProfileOfScoresFor(int motif, Sequence seq, int start) throws Exception {
        double[][] profiles = this.getAllProfilesOfScoresFor(motif, seq, start);
        return this.joinMethod.joinProfiles(profiles);
    }

    private void fillSortedScoresArray(int motif, int start) throws Exception {
        int t;
        double w;
        int num = 0;
        Sequence bgSeq = null;
        double[] temp = null;
        double sum = 0.0;
        int h = start + this.disc.getMotifLength(motif) - 1;
        int i = 0;
        while (i < this.numSequences) {
            w = this.weights == null ? 1.0 : this.weights[i];
            bgSeq = this.bg.getElementAt(i);
            t = bgSeq.getLength() - h;
            num += t;
            sum += (double)t * w;
            ++i;
        }
        double thresh = sum * this.sign;
        num = (int)Math.ceil(this.sign * (double)num);
        this.sortedScores = new double[2][num];
        this.sortedScores[0][0] = Double.NEGATIVE_INFINITY;
        Arrays.fill(this.sortedScores[1], 0.0);
        int stop = 1;
        double partSum = 0.0;
        i = 0;
        while (i < this.numSequences) {
            bgSeq = this.bg.getElementAt(i);
            temp = this.getJointProfileOfScoresFor(motif, bgSeq, start);
            Arrays.sort(temp);
            w = this.weights == null ? 1.0 : this.weights[i];
            t = temp.length - 1;
            while (t >= 0) {
                int s;
                int index;
                int idx = Arrays.binarySearch(this.sortedScores[0], 0, stop, temp[t]);
                boolean match = idx >= 0;
                int n = index = !match ? -idx - 1 : idx;
                if (index == 0) break;
                if (index == 1 && partSum > thresh && !match) {
                    this.sortedScores[0][0] = temp[t];
                    break;
                }
                partSum += w;
                int j = 1;
                double del = 0.0;
                while (j < index && partSum - (del + this.sortedScores[1][j]) > thresh) {
                    del += this.sortedScores[1][j];
                    ++j;
                }
                if (j > 1) {
                    this.sortedScores[0][0] = this.sortedScores[0][j - 1];
                    double[] dArray = this.sortedScores[1];
                    dArray[0] = dArray[0] + del;
                    partSum -= del;
                }
                if (stop == this.sortedScores[0].length && !match && j == 1) {
                    double[][] help = new double[2][2 * this.sortedScores[0].length];
                    System.arraycopy(this.sortedScores[0], 0, help[0], 0, stop);
                    System.arraycopy(this.sortedScores[1], 0, help[1], 0, stop);
                    this.sortedScores = help;
                }
                if (j != 1) {
                    System.arraycopy(this.sortedScores[0], j, this.sortedScores[0], 1, index - 1 - j + 1);
                    System.arraycopy(this.sortedScores[1], j, this.sortedScores[1], 1, index - 1 - j + 1);
                }
                if ((s = index - j + 1 + (match ? 0 : 1)) != index) {
                    System.arraycopy(this.sortedScores[0], index, this.sortedScores[0], s, stop - index);
                    System.arraycopy(this.sortedScores[1], index, this.sortedScores[1], s, stop - index);
                }
                if (match) {
                    double[] dArray = this.sortedScores[1];
                    int n2 = s;
                    dArray[n2] = dArray[n2] + w;
                } else {
                    this.sortedScores[0][--s] = temp[t];
                    this.sortedScores[1][s] = w;
                }
                stop = stop - (j - 1) + (match ? 0 : 1);
                --t;
            }
            if (t >= 0) {
                double[] dArray = this.sortedScores[1];
                dArray[0] = dArray[0] + w * (double)(t + 1);
            }
            ++i;
        }
        if (stop < this.sortedScores[0].length) {
            double[][] help = new double[2][stop];
            System.arraycopy(this.sortedScores[0], 0, help[0], 0, stop);
            System.arraycopy(this.sortedScores[1], 0, help[1], 0, stop);
            this.sortedScores = help;
        }
        sum = 0.0;
        i = this.sortedScores[0].length - 1;
        while (i >= 0) {
            this.sortedScores[1][i] = sum += this.sortedScores[1][i];
            --i;
        }
        i = this.sortedScores[0].length - 1;
        while (i > 0) {
            this.sortedScores[1][i] = this.sortedScores[1][i] / sum;
            --i;
        }
        this.sortedScores[1][0] = Double.NaN;
    }

    private void findSignificantMotifOccurrences(int motif, Sequence seq, int start, AbstractList<MotifAnnotation> annotation, int addMax, AbstractList<Sequence> sites, int addLeftSymbols, int addRightSymbols) throws Exception {
        if (!this.oneHistogram) {
            this.createBgDataSet(seq);
            this.fillSortedScoresArray(motif, start);
        }
        double[][] allProfs = this.getAllProfilesOfScoresFor(motif, seq, start);
        double[] joined = this.joinMethod.joinProfiles(allProfs);
        double thresh = this.sortedScores[0][1];
        int length = this.disc.getMotifLength(motif);
        int annotIndex = annotation != null ? annotation.size() : 0;
        int siteIndex = sites != null ? sites.size() : 0;
        DoubleList pValues = new DoubleList();
        double[] probs = new double[2];
        double[] tempStrandProbs = null;
        double[] tempCompProbs = new double[allProfs.length];
        int j = 0;
        while (j < joined.length) {
            if (joined[j] > thresh) {
                try {
                    int c = 0;
                    while (c < tempCompProbs.length) {
                        tempCompProbs[c] = Math.exp(allProfs[c][j] - joined[j]);
                        ++c;
                    }
                    probs[1] = 0.0;
                    probs[0] = 0.0;
                    int i = 0;
                    while (i < tempCompProbs.length) {
                        tempStrandProbs = this.disc.getStrandProbabilitiesFor(this.globalToLocalIndexes[motif][0][i], this.globalToLocalIndexes[motif][1][i], seq, start + j);
                        int s = 0;
                        while (s < probs.length) {
                            int n = s;
                            probs[n] = probs[n] + tempStrandProbs[s] * tempCompProbs[i];
                            ++s;
                        }
                        ++i;
                    }
                    if (sites != null) {
                        Sequence site = probs[1] > probs[0] ? seq.getSubSequence(j + start - addRightSymbols, length + addLeftSymbols + addRightSymbols).reverseComplement() : seq.getSubSequence(j + start - addLeftSymbols, length + addLeftSymbols + addRightSymbols);
                        sites.add(site);
                    }
                    double pVal = SignificantMotifOccurrencesFinder.getPValue(this.sortedScores[0], joined[j], this.sortedScores[1]);
                    pValues.add(pVal);
                    if (annotation != null) {
                        annotation.add(new MotifAnnotation("motif* " + motif, j + start, length, probs[1] > probs[0] ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD, new NumericalResult("component", "the component of the model where this motif was found with the highest probability", this.globalToLocalIndexes[motif][0][SignificantMotifOccurrencesFinder.getIndexOfMax(tempCompProbs)]), new NumericalResult("p-value", "", pVal), new NumericalResult("score", "", joined[j]), new NumericalResult("forward probability", "probability of the forward strand", probs[0])));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++j;
        }
        if (pValues.length() > addMax) {
            double[] array = pValues.toArray();
            Arrays.sort(array);
            int i = 0;
            while (i < pValues.length()) {
                if (pValues.get(i) >= array[addMax]) {
                    if (annotation != null) {
                        annotation.remove(annotIndex);
                    }
                    if (sites != null) {
                        sites.remove(siteIndex);
                    }
                } else {
                    ++annotIndex;
                    ++siteIndex;
                }
                ++i;
            }
        }
    }

    private static double getPValue(double[] sortedScores, double myScore, double[] cumulative) {
        int idx = PValueComputation.getIndex(sortedScores, myScore, 0);
        return idx >= cumulative.length ? 0.0 : cumulative[idx];
    }

    private int getLocalIndexOfMotifInComponent(int component, int motif) {
        int i = 0;
        while (i < this.disc.getNumberOfMotifsInComponent(component)) {
            if (this.disc.getGlobalIndexOfMotifInComponent(component, i) == motif) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void prepareIndices() {
        int n = this.disc.getNumberOfMotifs();
        this.globalToLocalIndexes = new int[n][][];
        int i = 0;
        while (i < n) {
            this.globalToLocalIndexes[i] = this.computeIndices(i);
            ++i;
        }
    }

    private int[][] computeIndices(int motif) {
        int num = 0;
        int i = 0;
        while (i < this.disc.getNumberOfComponents()) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc > -1) {
                ++num;
            }
            ++i;
        }
        int[][] idxs = new int[2][num];
        num = 0;
        int i2 = 0;
        while (i2 < this.disc.getNumberOfComponents()) {
            int loc = this.getLocalIndexOfMotifInComponent(i2, motif);
            if (loc > -1) {
                idxs[0][num] = i2;
                idxs[1][num] = loc;
                ++num;
            }
            ++i2;
        }
        return idxs;
    }

    public MotifAnnotation[] findSignificantMotifOccurrences(int motif, Sequence seq, int start) throws Exception {
        return this.findSignificantMotifOccurrences(motif, seq, Integer.MAX_VALUE, start);
    }

    public MotifAnnotation[] findSignificantMotifOccurrences(int motif, Sequence seq, int addMax, int start) throws Exception {
        LinkedList<MotifAnnotation> list = new LinkedList<MotifAnnotation>();
        if (this.oneHistogram) {
            this.fillSortedScoresArray(motif, start);
        }
        this.findSignificantMotifOccurrences(motif, seq, start, list, addMax, null, 0, 0);
        return list.toArray(new MotifAnnotation[0]);
    }

    public double[][] getPWM(int motif, DataSet data, double[] weights, int addLeft, int addRight) throws Exception {
        return this.getPWMAndPositions(motif, data, weights, addLeft, addRight, null, null, null, null, null, null);
    }

    public Pair<double[][][], int[][]> getPWMAndPositions(int motif, DataSet data, double[] weights, int addLeft, int addRight) throws Exception {
        int[][] positions = new int[data.getNumberOfElements()][];
        double[][] pvals = new double[data.getNumberOfElements()][];
        double[][] pwm = this.getPWMAndPositions(motif, data, weights, addLeft, addRight, positions, pvals, null, null, null, null);
        return new Pair<double[][][], int[][]>(new double[][][]{pwm, pvals}, positions);
    }

    protected double[][] getPWMAndPositions(int motif, DataSet data, double[] weights, int addLeft, int addRight, int[][] positions, double[][] pvals, double[] mean, double[] sd, LinkedList<Sequence> bs, DoubleList bsWeights) throws Exception {
        ArrayList<MotifAnnotation> list = new ArrayList<MotifAnnotation>();
        if (this.oneHistogram) {
            this.fillSortedScoresArray(motif, 0);
        }
        double n = 0.0;
        if (mean != null && sd != null) {
            sd[0] = 0.0;
        }
        double w = 1.0;
        ComplementableDiscreteAlphabet abc = null;
        try {
            abc = (ComplementableDiscreteAlphabet)data.getAlphabetContainer().getAlphabetAt(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double[][] pwm = new double[addLeft + addRight + this.disc.getMotifLength(motif)][(int)data.getAlphabetContainer().getAlphabetLengthAt(0)];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            if (weights != null) {
                w = weights[i];
            }
            Sequence seq = data.getElementAt(i);
            this.findSignificantMotifOccurrences(motif, seq, 0, list, Integer.MAX_VALUE, null, 0, 0);
            if (positions != null) {
                positions[i] = new int[list.size()];
            }
            if (pvals != null) {
                pvals[i] = new double[list.size()];
            }
            if (mean != null && sd != null) {
                w /= (double)list.size();
            }
            int j = 0;
            while (j < list.size()) {
                MotifAnnotation ma = list.get(j);
                if (positions != null) {
                    positions[i][j] = ma.getPosition();
                }
                if (pvals != null) {
                    pvals[i][j] = (Double)ma.getResultForName("p-value").getValue();
                }
                int start = ma.getPosition() - addLeft;
                if (mean != null && sd != null) {
                    sd[0] = sd[0] + w * ((double)start - mean[i]) * ((double)start - mean[i]);
                    n += w;
                }
                int end = ma.getEnd() + addRight;
                StrandedLocatedSequenceAnnotationWithLength.Strand strand = ma.getStrandedness();
                if (positions != null && strand == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE) {
                    positions[i][j] = -positions[i][j] - 1;
                }
                switch (strand) {
                    case FORWARD: {
                        if (bs != null && start >= 0 && end <= seq.getLength()) {
                            bs.add(seq.getSubSequence(start, end - start));
                            bsWeights.add(w);
                        }
                        int l = 0;
                        while (start < end && start < seq.getLength()) {
                            if (start >= 0) {
                                double[] dArray = pwm[l];
                                int n2 = seq.discreteVal(start);
                                dArray[n2] = dArray[n2] + w;
                            }
                            ++l;
                            ++start;
                        }
                        break;
                    }
                    case REVERSE: {
                        int l = pwm.length - 1;
                        if (bs != null && start >= 0 && end <= seq.getLength()) {
                            bs.add(seq.getSubSequence(start, end - start).reverseComplement());
                            bsWeights.add(w);
                        }
                        while (start < end && start < seq.getLength()) {
                            if (start >= 0) {
                                double[] dArray = pwm[l];
                                int n3 = abc.getComplementaryCode(seq.discreteVal(start));
                                dArray[n3] = dArray[n3] + w;
                            }
                            --l;
                            ++start;
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                ++j;
            }
            list.clear();
            ++i;
        }
        if (mean != null && sd != null) {
            sd[0] = Math.sqrt(sd[0] / n);
        }
        i = 0;
        while (i < pwm.length) {
            Normalisation.sumNormalisation(pwm[i]);
            ++i;
        }
        return pwm;
    }

    public Pair<double[][], double[]> getPWMAndPosDist(int motif, DataSet data, double[] weights, double[] mean, int addLeft, int addRight) throws Exception {
        double[] sd = new double[1];
        double[][] pwm = this.getPWMAndPositions(motif, data, weights, addLeft, addRight, null, null, mean, sd, null, null);
        return new Pair<double[][], double[]>(pwm, sd);
    }

    public Pair<double[][], double[]> getPWMAndPosDist(int motif, DataSet data, double[] weights, double[] mean, int addLeft, int addRight, LinkedList<Sequence> bs, DoubleList bsWeight) throws Exception {
        double[] sd = new double[1];
        double[][] pwm = this.getPWMAndPositions(motif, data, weights, addLeft, addRight, null, null, mean, sd, bs, bsWeight);
        return new Pair<double[][], double[]>(pwm, sd);
    }

    public DataSet annotateMotif(DataSet data, int motifIndex) throws Exception {
        return this.annotateMotif(0, data, motifIndex);
    }

    public DataSet annotateMotif(int startPos, DataSet data, int motifIndex) throws Exception {
        return this.annotateMotif(startPos, data, motifIndex, Integer.MAX_VALUE, false);
    }

    public DataSet annotateMotif(DataSet data, int motifIndex, int addMax) throws Exception {
        return this.annotateMotif(0, data, motifIndex, addMax, false);
    }

    public DataSet annotateMotif(int startPos, DataSet data, int motifIndex, int addMax, boolean addAnnotation) throws Exception {
        return (DataSet)this.predictBS(startPos, data, null, motifIndex, addMax, 0, 0, addAnnotation).get(0);
    }

    public DataSet getBindingSites(DataSet data, int motifIndex) throws Exception {
        return this.getBindingSites(0, data, motifIndex, Integer.MAX_VALUE, 0, 0);
    }

    public DataSet getBindingSites(int startPos, DataSet data, int motifIndex, int addMax, int addLeft, int addRight) throws Exception {
        return (DataSet)this.predictBS(startPos, data, null, motifIndex, addMax, addLeft, addRight, false).get(1);
    }

    public IntList getStartPositions(int startPos, DataSet data, int motifIndex, int addMax) throws Exception {
        return (IntList)this.predictBS(startPos, data, null, motifIndex, addMax, 0, 0, false).get(3);
    }

    public double getNumberOfBoundSequences(DataSet data, double[] weights, int motifIndex) throws Exception {
        return (Double)this.predictBS(0, data, weights, motifIndex, Integer.MAX_VALUE, 0, 0, false).get(2);
    }

    public double getOffsetForAucPR() {
        return !this.oneHistogram ? 1 : 0;
    }

    public double getFactorForAucPR() {
        return this.oneHistogram ? 1 : -1;
    }

    public double[][] getValuesForEachNucleotide(DataSet data, int motif, boolean addOnlyBest) throws Exception {
        double[][] res = new double[data.getNumberOfElements()][];
        if (this.oneHistogram) {
            this.fillSortedScoresArray(motif, 0);
        }
        int i = 0;
        while (i < res.length) {
            res[i] = this.getValueForNucleotides(data.getElementAt(i), 0, motif, addOnlyBest);
            ++i;
        }
        return res;
    }

    private static int getIndexOfMax(double ... values) {
        int idx = 0;
        int i = 1;
        while (i < values.length) {
            if (values[i] > values[idx]) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    private double[] getValueForNucleotides(Sequence seq, int start, int motif, boolean addOnlyBest) throws Exception {
        double[] res;
        block4: {
            int length;
            double[] temp;
            block3: {
                if (!this.oneHistogram) {
                    this.createBgDataSet(seq);
                    this.fillSortedScoresArray(motif, start);
                }
                temp = this.getJointProfileOfScoresFor(motif, seq, start);
                length = this.disc.getMotifLength(motif);
                if (!addOnlyBest) break block3;
                res = new double[seq.getLength() - start];
                Arrays.fill(res, this.oneHistogram ? Double.NEGATIVE_INFINITY : 1.0);
                int idx = SignificantMotifOccurrencesFinder.getIndexOfMax(temp);
                double best = this.oneHistogram ? temp[idx] : SignificantMotifOccurrencesFinder.getPValue(this.sortedScores[0], temp[idx], this.sortedScores[1]);
                int i = 0;
                while (i < length) {
                    res[idx + i] = best;
                    ++i;
                }
                break block4;
            }
            res = SignificantMotifOccurrencesFinder.smooth(temp, seq.getLength() - start, length);
            if (this.oneHistogram) break block4;
            int i = 0;
            while (i < temp.length) {
                res[i] = SignificantMotifOccurrencesFinder.getPValue(this.sortedScores[0], temp[i], this.sortedScores[1]);
                ++i;
            }
        }
        return res;
    }

    private static double[] smooth(double[] temp, int seqLength, int motifLength) {
        double[] res = new double[seqLength];
        Arrays.fill(res, temp[temp.length - 1]);
        System.arraycopy(temp, 0, res, 0, temp.length);
        int i = res.length - 1;
        while (i >= 0) {
            int k = i - 1;
            int j = 1;
            while (j < motifLength && k >= 0) {
                if (res[i] < res[k]) {
                    res[i] = res[k];
                }
                ++j;
                --k;
            }
            --i;
        }
        return res;
    }

    private ArrayList predictBS(int startPos, DataSet data, double[] weights, int motif, int addMax, int addLeft, int addRight, boolean addAnnotation) throws Exception {
        DataSet bs;
        int n = data.getNumberOfElements();
        Sequence[] seqs = new Sequence[n];
        IntList posList = new IntList();
        LinkedList<MotifAnnotation> seqAn = new LinkedList<MotifAnnotation>();
        LinkedList<Sequence> bsList = new LinkedList<Sequence>();
        LinkedList<Sequence> currentList = new LinkedList<Sequence>();
        SequenceAnnotation[] empty = new SequenceAnnotation[]{};
        if (this.oneHistogram) {
            this.createBgDataSet(data);
            this.fillSortedScoresArray(motif, startPos);
        }
        double weight = 1.0;
        double bound = 0.0;
        int i = 0;
        while (i < n) {
            seqs[i] = data.getElementAt(i);
            if (weights != null) {
                weight = weights[i];
            }
            seqAn.clear();
            this.findSignificantMotifOccurrences(motif, seqs[i], startPos, seqAn, addMax, currentList, addLeft, addRight);
            if (currentList.size() > 0) {
                bound += weight;
                bsList.addAll(currentList);
                currentList.clear();
            }
            seqs[i] = seqs[i].annotate(addAnnotation, seqAn.toArray(empty));
            int k = 0;
            while (k < seqAn.size()) {
                MotifAnnotation current = seqAn.get(k);
                posList.add(current.getPosition());
                ++k;
            }
            ++i;
        }
        ArrayList<Object> res = new ArrayList<Object>(4);
        res.add(new DataSet("annotated sample", seqs));
        try {
            bs = new DataSet("annotated binding sites", bsList.toArray(new Sequence[0]));
        }
        catch (Exception e) {
            bs = null;
        }
        res.add(bs);
        res.add(bound);
        res.add(posList);
        return res;
    }

    public MotifDiscoverer getMotifDiscoverer() throws CloneNotSupportedException {
        return this.disc.clone();
    }

    public static interface JoinMethod {
        public double[] joinProfiles(double[][] var1) throws Exception;
    }

    public static enum RandomSeqType {
        BACKGROUND(-2),
        PERMUTED(-1),
        hMM0(0),
        hMM1(1),
        hMM2(2),
        hMM3(3),
        hMM4(4),
        hMM5(5);

        private final int order;

        private RandomSeqType(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }

    public static class SumOfProbabilities
    implements JoinMethod {
        @Override
        public double[] joinProfiles(double[][] profiles) {
            double[] res = new double[profiles[0].length];
            int i = 0;
            while (i < profiles.length) {
                if (profiles[i].length != res.length) {
                    throw new IllegalArgumentException("Profiles must be of same length, but profile " + i + " has length " + profiles[i].length + " instead of " + res.length);
                }
                ++i;
            }
            double[] temp = new double[profiles.length];
            int i2 = 0;
            while (i2 < res.length) {
                int j = 0;
                while (j < temp.length) {
                    temp[j] = profiles[j][i2];
                    ++j;
                }
                res[i2] = Normalisation.getLogSum(temp);
                ++i2;
            }
            return res;
        }
    }
}

