/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;

public class JDBCPooledDataSource {
    public static DataSource getDataSource(String driver, String url, String user, String pass) throws Exception {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(url);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        ds.setMaxActive(10);
        ds.setMaxIdle(5);
        ds.setMaxWait(10000L);
        return ds;
    }

    public static void main(String[] args) {
        try {
            DataSource ds1 = JDBCPooledDataSource.getDataSource("org.hsqldb.jdbcDriver", "jdbc:hsqldb:/tmp/hsqldb/biosql", "sa", "");
            DataSource ds2 = JDBCPooledDataSource.getDataSource("org.hsqldb.jdbcDriver", "jdbc:hsqldb:/tmp/hsqldb/biosql", "sa", "");
            System.err.println(ds1);
            System.err.println(ds2);
            System.err.println(ds1.equals(ds2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class MyPoolingDataSource
    extends PoolingDataSource {
        final String source;

        public MyPoolingDataSource(ObjectPool connectionPool, String source) {
            super(connectionPool);
            this.source = source;
        }

        public boolean equals(Object o2) {
            if (o2 == null || !(o2 instanceof MyPoolingDataSource)) {
                return false;
            }
            MyPoolingDataSource b2 = (MyPoolingDataSource)((Object)o2);
            return this.source.equals(b2.source);
        }

        public int hashCode() {
            return this.source.hashCode();
        }
    }
}

