/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.bio.BioError;

public class WeightedSet
extends AbstractSet
implements Serializable {
    private HashMap key2Weight = new HashMap();
    double totalWeight;

    public Map asMap() {
        return this.key2Weight;
    }

    public Object sample() {
        double p = Math.random();
        for (Object o : this) {
            double weight = this.getWeight(o);
            if (!((p -= weight) <= 0.0)) continue;
            return o;
        }
        throw new BioError("Cannot sample an object, does this set contain any objects?");
    }

    public double getWeight(Object o) throws NoSuchElementException {
        if (!this.key2Weight.containsKey(o)) {
            throw new NoSuchElementException(o + " not found in this WeightedSet");
        }
        Double d = (Double)this.key2Weight.get(o);
        if (this.totalWeight == 0.0) {
            return 0.0;
        }
        return d / this.totalWeight;
    }

    protected double getTotalWeight() {
        return this.totalWeight;
    }

    public void setWeight(Object o, double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("Weight must be >= 0.0");
        }
        if (this.key2Weight.containsKey(o)) {
            this.remove(o);
        }
        this.totalWeight += w;
        this.key2Weight.put(o, new Double(w));
    }

    public boolean contains(Object o) {
        return this.key2Weight.containsKey(o);
    }

    public boolean remove(Object o) {
        if (this.key2Weight.containsKey(o)) {
            this.totalWeight -= ((Double)this.key2Weight.get(o)).doubleValue();
            this.key2Weight.remove(o);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.key2Weight.isEmpty();
    }

    public boolean retainAll(Collection c) {
        boolean b = false;
        ArrayList toRemove = new ArrayList();
        for (Object item : this) {
            if (c.contains(item)) continue;
            b = true;
            toRemove.add(item);
        }
        this.removeAll(toRemove);
        return b;
    }

    public boolean add(Object o) {
        boolean b = !this.key2Weight.containsKey(o);
        this.setWeight(o, 0.0);
        return b;
    }

    public int size() {
        return this.key2Weight.size();
    }

    public boolean containsAll(Collection c) {
        if (this.size() == 0) {
            return false;
        }
        for (Object item : this) {
            if (this.key2Weight.containsKey(item)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        Object[] o = new Object[this.size()];
        int j = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            o[j++] = i.next();
        }
        return o;
    }

    public void clear() {
        this.key2Weight = new HashMap();
        this.totalWeight = 0.0;
    }

    public Iterator iterator() {
        return Collections.unmodifiableSet(this.key2Weight.keySet()).iterator();
    }

    public boolean addAll(Collection c) {
        boolean b = false;
        for (Object item : c) {
            if (!this.key2Weight.containsKey(item)) {
                b = true;
            }
            this.add(item);
        }
        return b;
    }
}

