/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SixFrameRenderer;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class StopRenderer
implements SequenceRenderer {
    private double scaleThreshold = 0.005;
    private SixFrameRenderer pane;
    private int moduloFrame;
    private StrandedFeature.Strand strand;

    public StopRenderer(SixFrameRenderer pane, int moduloFrame, StrandedFeature.Strand strand) {
        this.pane = pane;
        this.moduloFrame = moduloFrame;
        this.strand = strand;
    }

    public double getDepth(SequenceRenderContext src) {
        if (src.getScale() < this.scaleThreshold) {
            return 0.0;
        }
        return this.pane.getDepth(src);
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    private boolean isStop(SymbolList seq, int base, StrandedFeature.Strand strand) {
        if (strand == StrandedFeature.POSITIVE) {
            if (base + 2 > seq.length()) {
                return false;
            }
            if (seq.symbolAt(base) != DNATools.t()) {
                return false;
            }
            if (seq.symbolAt(base + 1) == DNATools.c()) {
                return false;
            }
            if (seq.symbolAt(base + 1) == DNATools.t()) {
                return false;
            }
            if (seq.symbolAt(base + 1) == DNATools.g()) {
                if (seq.symbolAt(base + 2) != DNATools.a()) {
                    return false;
                }
            } else {
                if (seq.symbolAt(base + 2) == DNATools.c()) {
                    return false;
                }
                if (seq.symbolAt(base + 2) == DNATools.t()) {
                    return false;
                }
            }
            return true;
        }
        if (base - 2 < 1) {
            return false;
        }
        if (seq.symbolAt(base) != DNATools.a()) {
            return false;
        }
        if (seq.symbolAt(base - 1) == DNATools.a()) {
            return false;
        }
        if (seq.symbolAt(base - 1) == DNATools.g()) {
            return false;
        }
        if (seq.symbolAt(base - 1) == DNATools.c()) {
            if (seq.symbolAt(base - 2) != DNATools.t()) {
                return false;
            }
        } else {
            if (seq.symbolAt(base - 2) == DNATools.a()) {
                return false;
            }
            if (seq.symbolAt(base - 2) == DNATools.g()) {
                return false;
            }
        }
        return true;
    }

    private void renderOneFrame(Graphics2D g, SequenceRenderContext src, RangeLocation range, boolean onceOnly) {
        SymbolList seq = src.getSymbols();
        int minS = range.getMin();
        int maxS = range.getMax();
        if (minS % 3 > this.moduloFrame) {
            minS = (minS / 3 + 1) * 3 + this.moduloFrame;
        } else if (minS % 3 != this.moduloFrame) {
            minS = minS / 3 * 3 + this.moduloFrame;
        }
        for (int base = minS; base <= maxS; base += 3) {
            if (!this.isStop(seq, base, this.strand)) continue;
            this.pane.drawLine(g, src, base, this.strand);
            if (!onceOnly) continue;
            return;
        }
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        double scale = src.getScale();
        if (scale < this.scaleThreshold) {
            return;
        }
        if (scale < 0.05) {
            for (RangeLocation range : this.pane.sequenceExtentOfPixels(src)) {
                this.renderOneFrame(g, src, range, true);
            }
        } else {
            this.renderOneFrame(g, src, src.getRange(), false);
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        int sPos = src.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }
}

