/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import java.util.ListIterator;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.GAMESeqRelPropHandler;
import org.biojava.bio.seq.io.game.GAMETranscriptCallbackItf;
import org.biojava.bio.seq.io.game.GAMETypePropHandler;
import org.biojava.bio.seq.io.game.StAXFeatureHandler;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.xml.sax.Attributes;

public class GAMEFeatureSpanHandler
extends StAXFeatureHandler {
    private StAXFeatureHandler staxenv;
    public static final StAXHandlerFactory GAME_FEATURESPAN_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEFeatureSpanHandler(staxenv);
        }
    };

    GAMEFeatureSpanHandler(StAXFeatureHandler staxenv) {
        this.staxenv = staxenv;
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("feature_span", false);
        super.addHandler(new ElementRecognizer.ByLocalName("type"), GAMETypePropHandler.GAME_TYPE_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("seq_relationship"), GAMESeqRelPropHandler.GAME_SEQREL_PROP_HANDLER_FACTORY);
    }

    protected Feature.Template createTemplate() {
        StrandedFeature.Template ft = new StrandedFeature.Template();
        ft.annotation = new SmallAnnotation();
        ft.strand = StrandedFeature.UNKNOWN;
        return ft;
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) {
        String featureId = attrs.getValue("id");
        try {
            if (featureId != null) {
                this.featureTemplate.annotation.setProperty("id", featureId);
            }
        }
        catch (ChangeVetoException cve) {
            System.err.println("GAMEFeatureSpanHandler. Change blocked.");
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) {
        if (!this.featureTemplate.type.equals("exon")) {
            return;
        }
        int currLevel = this.staxenv.getLevel();
        if (currLevel >= 1) {
            ListIterator li = this.staxenv.getHandlerStackIterator(currLevel);
            while (li.hasPrevious()) {
                Object ob = li.previous();
                if (!(ob instanceof GAMETranscriptCallbackItf)) continue;
                ((GAMETranscriptCallbackItf)ob).reportExon((RangeLocation)((StrandedFeature.Template)this.featureTemplate).location, ((StrandedFeature.Template)this.featureTemplate).strand);
                return;
            }
        }
    }
}

