wrapper <- function(table, columns, options) {

    # initialize output list
    l <- list()

    # loop through all columns
    for (key in names(columns)) {
        # load column data
        column <- as.numeric(columns[key])
        column_data <- sapply( table[column], as.numeric )

        # create hist data
        hist_data <- hist(column_data, plot=FALSE)

        # collect vectors in list
        l <- append(l, list(hist_data$breaks[2: length(hist_data$breaks)]))
        l <- append(l, list(hist_data$density))
    }
    
    # make sure length is fine
    n <- max(sapply(l, length))
    ll <- lapply(l, function(X) {
        c(as.character(X), rep("", times = n - length(X)))
    })
    l <- do.call(cbind, ll)

    # return
    return (l)
}
