# MicroBiomML

This repository contains supporting materials for the research article "_Large-scale classification of metagenomic samples: a comparative analysis of classical machine learning techniques vs a novel brain-inspired hyperdimensional computing approach_".

## Overview

MicroBiomML provides Galaxy tools and pipelines for running classical machine learning (ML) methods on metagenomic datasets sourced from the curatedMetagenomicData R package. In addition, it includes a dedicated Galaxy tool for comparing the performance of traditional ML techniques versus a new brain-inspired hyperdimensional computing (HDC) classification approach.

## Features

- __Classical Machine Learning Tools__: Scripts and workflows for applying common ML algorithms (e.g., Random Forest, Support Vector Machines, etc.) to metagenomic data.
- __HDC Tool__: An implementation of the hyperdimensional computing approach for the classification and feature selection of metagenomic data.
- __Galaxy Integration__: All tools and pipelines are wrapped as Galaxy tools for easy execution and reproducibility.

## Getting Started

### Prerequisites

- Galaxy installation
- R and the curatedMetagenomicData package

### Usage

- Install the Galaxy tools from this repository.
- Import metagenomic datasets via curatedMetagenomicData.
- Run the available ML or HDC pipelines within Galaxy.
- Compare results using the dedicated comparison tool.

## Citation

If you utilize these tools in your research, please cite:

> _Manuscript in preparation_

## Contact

For questions or further information, contact [Jayadev Joshi](mailto:joshij@ccf.org) and [Fabio Cumbo](mailto:cumbof@ccf.org).

## License

This work is distributed under the MIT License.