/*
 * Decompiled with CFR 0.152.
 */
package blosum2;

import blosum2.Blosum;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;

public final class Blosum2 {
    public static void main(String[] args) {
        Blosum blosum = new Blosum();
        String cwd = System.getProperty("user.dir");
        String filePath = args.length > 0 ? args[0] : cwd + "/input.csv";
        try {
            File f = new File(filePath);
            String outFilePath = cwd + "/BlosumOutput.csv";
            PrintWriter printer = new PrintWriter(outFilePath, "UTF-8");
            Scanner scan = new Scanner(f);
            String masterSeq = scan.nextLine();
            masterSeq = masterSeq.toUpperCase();
            char[] masterSeqArray = masterSeq.toCharArray();
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                line = line.toUpperCase();
                char[] lineArray = line.toCharArray();
                int totalDist = 0;
                if (masterSeq.length() != line.length()) {
                    System.out.println("Sequence " + line + " doesn't have the same length as the master sequence");
                    continue;
                }
                for (int i = 0; i < masterSeq.length(); ++i) {
                    totalDist += Blosum.getDistance(lineArray[i], masterSeqArray[i]);
                }
                printer.println(totalDist);
            }
            scan.close();
            printer.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to open file");
        }
        catch (IOException ex) {
            System.out.println("Error reading file");
        }
    }
}

