/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ArrayConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.awt.Color;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArrayConverter
extends ArrayConverter {
    public DefaultArrayConverter(String string, Class<?> clazz) {
        super(string, -1, clazz);
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = this.getElementClass() == Object.class ? (Object[])object : new Object[Array.getLength(object)];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = Array.get(object, i2);
            }
            return this.arrayToString(objectArray, converterContext);
        }
        return ObjectConverterManager.toString(object, this.getElementClass(), converterContext);
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        if (string == null || "".equals(string)) {
            return new Object[0];
        }
        Object[] objectArray = this.arrayFromString(string, converterContext);
        if (this.getElementClass() == Object.class) {
            return objectArray;
        }
        Object object = Array.newInstance(this.getElementClass(), objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object2 = objectArray[i2];
            Array.set(object, i2, object2);
        }
        return object;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).toString(new int[]{2, 3, 2, 4}, null));
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).fromString("2;3;2;4", null));
        System.out.println(new DefaultArrayConverter(";", Color.class).toString(new Color[]{Color.RED, Color.YELLOW, Color.GREEN}, HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Color.class).fromString("#FF0000;#FFFF00;#00FF00", HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Object.class).fromString("#FF0000;#FFFF00;#00FF00", null));
    }
}

