/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconsFactory {
    static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> disableIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> enhancedIcons = new HashMap<String, ImageIcon>();
    public static ImageIcon EMPTY_ICON = new ImageIcon(){

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public synchronized void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    };
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon getImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        Icon icon = icons.get(string2);
        if (icon != null) {
            return (ImageIcon)icon;
        }
        ImageIcon imageIcon = IconsFactory.createImageIcon(clazz, string);
        icons.put(string2, imageIcon);
        return imageIcon;
    }

    public static ImageIcon findImageIcon(Class<?> clazz, String string) throws IOException {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = icons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createImageIconWithException(clazz, string);
        icons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getDisabledImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = disableIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createGrayImage(IconsFactory.getImageIcon(clazz, string));
        disableIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = enhancedIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, string));
        enhancedIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String string, int n2) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = enhancedIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, string), n2);
        enhancedIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon createGrayImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }

    private static ImageIcon createGrayImage(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
    }

    public static ImageIcon createGrayImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        if (n2 == 0 || n3 == 0) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static ImageIcon createBrighterImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image));
    }

    public static ImageIcon createBrighterImage(Image image, int n2) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image, n2));
    }

    public static ImageIcon createBrighterImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(bufferedImage));
    }

    public static ImageIcon createBrighterImage(Component component, Icon icon, int n2) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(bufferedImage, n2));
    }

    public static ImageIcon createBrighterImage(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(imageIcon.getImage()));
    }

    public static ImageIcon createBrighterImage(ImageIcon imageIcon, int n2) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(imageIcon.getImage(), n2));
    }

    public static ImageIcon createNegativeImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(MaskFilter.createNegativeImage(image));
    }

    private static ImageIcon createNegativeImage(ImageIcon imageIcon) {
        return new ImageIcon(MaskFilter.createNegativeImage(imageIcon.getImage()));
    }

    public static ImageIcon createMaskImage(Component component, Icon icon, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createImage(bufferedImage, color, color2));
    }

    public static ImageIcon createRotatedImage(Component component, Icon icon, double d2) {
        int n2;
        int n3;
        double d3 = d2 % 360.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 360.0;
        }
        double d4 = d3 % 90.0;
        if (d3 != 0.0 && d4 == 0.0) {
            d4 = 90.0;
        }
        double d5 = Math.toRadians(d4);
        int n4 = icon.getIconWidth();
        int n5 = icon.getIconHeight();
        if (d3 >= 0.0 && d3 <= 90.0 || d3 > 180.0 && d3 <= 270.0) {
            n3 = (int)Math.round((double)n4 * Math.sin(1.5707963267948966 - d5) + (double)n5 * Math.sin(d5));
            n2 = (int)Math.round((double)n4 * Math.sin(d5) + (double)n5 * Math.sin(1.5707963267948966 - d5));
        } else {
            n3 = (int)((double)n5 * Math.sin(1.5707963267948966 - d5) + (double)n4 * Math.sin(d5));
            n2 = (int)((double)n5 * Math.sin(d5) + (double)n4 * Math.sin(1.5707963267948966 - d5));
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n6 = n4 / 2;
        int n7 = n5 / 2;
        int n8 = n4 % 2 != 0 && d3 >= 90.0 && d3 <= 180.0 ? 1 : 0;
        int n9 = n4 % 2 != 0 && d3 >= 180.0 && d3 < 360.0 ? 1 : 0;
        graphics2D.translate(n3 / 2 + n8, n2 / 2 + n9);
        graphics2D.rotate(Math.toRadians(d3));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(component, graphics2D, -n6, -n7);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createNegativeImage(Component component, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createNegativeImage(bufferedImage));
    }

    private static void doPrivileged(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                runnable.run();
                return null;
            }
        });
    }

    private static ImageIcon createImageIcon(Class<?> clazz, String string) {
        try {
            return IconsFactory.createImageIconWithException(clazz, string);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return null;
        }
    }

    private static ImageIcon createImageIconWithException(Class<?> clazz, String string) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            System.err.println("Image file " + string + " is missing");
            return null;
        }
        return new ImageIcon(ImageIO.read(inputStream));
    }

    public static void generateHTML(Class<?> clazz) {
        String string = clazz.getName();
        String string2 = IconsFactory.getClassName(string);
        File file = new File(string + ".html");
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<html>\n<body>\n<p><b><font size=\"5\" face=\"Verdana\">Icons in " + string + "</font></b></p>");
            fileWriter.write("<p><b><font size=\"3\" face=\"Verdana\">Generated by JIDE Icons</font></b></p>");
            fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">1. If you cannot view the images in this page, make sure the file is at the same directory as " + string2 + ".java</font></b></p>");
            fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">2. To get a particular icon in your code, call " + string2 + ".getImageIcon(FULL_CONSTANT_NAME). Replace FULL_CONSTANT_NAME with the actual " + "full constant name as in the table below" + "</font></b></p>");
            IconsFactory.generate(clazz, fileWriter, string2);
            fileWriter.write("\n</body>\n</html>");
            fileWriter.close();
            System.out.println("File is generated at \"" + file.getAbsolutePath() + "\". Please copy it to the same directory as " + string2 + ".java");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static String getClassName(String string) {
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(".");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static void generate(Class<?> clazz, FileWriter fileWriter, String string) throws IOException {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        for (int i2 = classArray.length - 1; i2 >= 0; --i2) {
            Field[] fieldArray = classArray[i2];
            IconsFactory.generate(fieldArray, fileWriter, IconsFactory.getClassName(fieldArray.getName()));
        }
        Field[] fieldArray = clazz.getFields();
        fileWriter.write("<p><font face=\"Verdana\"><b>" + string + "</b></font></p>");
        fileWriter.write("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#CCCCCC\" width=\"66%\">");
        fileWriter.write("<tr>\n");
        fileWriter.write("<td width=\"24%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Name</font></b></td>\n");
        fileWriter.write("<td width=\"13%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Image</font></b></td>\n");
        fileWriter.write("<td width=\"32%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">File Name</font></b></td>\n");
        fileWriter.write("<td width=\"31%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Full Constant Name</font></b></td>\n");
        fileWriter.write("</tr>\n");
        for (Field field : fieldArray) {
            try {
                String string2 = field.getName();
                Object object = field.get(clazz);
                fileWriter.write("<tr>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string2 + "</font></td>\n");
                fileWriter.write("<td align=\"center\"><font face=\"Verdana\"><img border=\"0\" src=\"" + object + "\"></font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + object + "</font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string + "." + string2 + "</font></td>\n");
                fileWriter.write("</tr>\n");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        fileWriter.write("</table><br><p>\n");
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5) {
        return IconsFactory.getIcon(component, imageIcon, n2, n3, n4, n5, n4, n5);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5, int n6, int n7) {
        return IconsFactory.getIcon(component, imageIcon, n2, n3, n4, n5, 2, n6, n7);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5, int n6) {
        return IconsFactory.getIcon(component, imageIcon, n2, n3, n4, n5, n6, n4, n5);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (imageIcon == null || n2 < 0 || n2 + n4 > imageIcon.getIconWidth() || n3 < 0 || n3 + n5 > imageIcon.getIconHeight()) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(n7, n8, n6);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n7, n8, n2, n3, n2 + n4, n3 + n5, component);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n2) {
        return IconsFactory.getOverlayIcon(component, imageIcon, imageIcon2, n2, new Insets(0, 0, 0, 0));
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n2, Insets insets) {
        int n3 = -1;
        int n4 = -1;
        int n5 = imageIcon.getIconWidth();
        int n6 = imageIcon.getIconHeight();
        int n7 = imageIcon2.getIconWidth();
        int n8 = imageIcon2.getIconHeight();
        switch (n2) {
            case 0: {
                n3 = (n5 - n7) / 2;
                n4 = (n6 - n8) / 2;
                break;
            }
            case 1: {
                n3 = (n5 - n7) / 2;
                n4 = insets.top;
                break;
            }
            case 5: {
                n3 = (n5 - n7) / 2;
                n4 = n6 - insets.bottom - n8;
                break;
            }
            case 7: {
                n3 = insets.left;
                n4 = (n6 - n8) / 2;
                break;
            }
            case 3: {
                n3 = n5 - insets.right - n7;
                n4 = (n6 - n8) / 2;
                break;
            }
            case 2: {
                n3 = n5 - insets.right - n7;
                n4 = insets.top;
                break;
            }
            case 8: {
                n3 = insets.left;
                n4 = insets.top;
                break;
            }
            case 6: {
                n3 = insets.left;
                n4 = n6 - insets.bottom - n8;
                break;
            }
            case 4: {
                n3 = n5 - insets.right - n7;
                n4 = n6 - insets.bottom - n8;
            }
        }
        return IconsFactory.getOverlayIcon(component, imageIcon, imageIcon2, n3, n4);
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n2, int n3) {
        int n4 = imageIcon == null ? imageIcon2.getIconWidth() : imageIcon.getIconWidth();
        int n5 = imageIcon == null ? imageIcon2.getIconHeight() : imageIcon.getIconHeight();
        int n6 = imageIcon2.getIconWidth();
        int n7 = imageIcon2.getIconHeight();
        if (n2 != -1 && n3 != -1) {
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
            if (imageIcon != null) {
                bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n4, n5, component);
            }
            bufferedImage.getGraphics().drawImage(imageIcon2.getImage(), n2, n3, n6, n7, component);
            return new ImageIcon(bufferedImage);
        }
        return imageIcon;
    }

    public static ImageIcon getScaledImage(Component component, ImageIcon imageIcon, int n2, int n3) {
        if (n2 >= imageIcon.getIconWidth() / 2) {
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
        graphics2D.dispose();
        return new ImageIcon(JideSwingUtilities.getFasterScaledInstance(bufferedImage, n2, n3, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true));
    }
}

