/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Stroke;

public class StyleRange {
    public static final int STYLE_STRIKE_THROUGH = 1;
    public static final int STYLE_DOUBLE_STRIKE_THROUGH = 2;
    public static final int STYLE_WAVED = 4;
    public static final int STYLE_UNDERLINED = 8;
    public static final int STYLE_DOTTED = 16;
    public static final int STYLE_SUPERSCRIPT = 32;
    public static final int STYLE_SUBSCRIPT = 64;
    private final int _fontStyle;
    private final Color _fontColor;
    private final Color _backgroundColor;
    private final Color _lineColor;
    private final Stroke _lineStroke;
    private final int _additionalStyle;
    private final int _start;
    private final int _length;
    private float _fontShrinkRatio = 1.5f;

    public StyleRange(int n2) {
        this(0, -1, n2, null, 0, null, null);
    }

    public StyleRange(Color color) {
        this(0, -1, -1, color, 0, null, null);
    }

    public StyleRange(int n2, Color color) {
        this(0, -1, n2, color, 0, null, null);
    }

    public StyleRange(int n2, int n3) {
        this(0, -1, n2, null, n3, null, null);
    }

    public StyleRange(int n2, int n3, float f2) {
        this(0, -1, n2, null, n3, null, null, f2);
    }

    public StyleRange(int n2, int n3, int n4) {
        this(n2, n3, n4, null, 0, null, null);
    }

    public StyleRange(int n2, int n3, int n4, Color color) {
        this(n2, n3, n4, color, 0, null, null);
    }

    public StyleRange(int n2, int n3, Color color) {
        this(n2, n3, 0, color, 0, null, null);
    }

    public StyleRange(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, null, n5, null, null);
    }

    public StyleRange(int n2, int n3, int n4, int n5, float f2) {
        this(n2, n3, n4, null, n5, null, null, f2);
    }

    public StyleRange(int n2, Color color, int n3, Color color2) {
        this(0, -1, n2, color, n3, color2, null);
    }

    public StyleRange(int n2, Color color, Color color2, int n3, Color color3) {
        this(0, -1, n2, color, color2, n3, color3, null);
    }

    public StyleRange(int n2, int n3, int n4, Color color, int n5) {
        this(n2, n3, n4, color, n5, null, null);
    }

    public StyleRange(int n2, int n3, int n4, Color color, Color color2, int n5) {
        this(n2, n3, n4, color, color2, n5, null, null);
    }

    public StyleRange(int n2, Color color, int n3, Color color2, Stroke stroke) {
        this(0, -1, n2, color, n3, color2, stroke);
    }

    public StyleRange(int n2, int n3, int n4, Color color, int n5, Color color2) {
        this(n2, n3, n4, color, n5, color2, null);
    }

    public StyleRange(int n2, int n3, int n4, Color color, Color color2, int n5, Color color3) {
        this(n2, n3, n4, color, color2, n5, color3, null);
    }

    public StyleRange(int n2, int n3, int n4, Color color, int n5, Color color2, Stroke stroke) {
        this(n2, n3, n4, color, n5, color2, stroke, 1.5f);
    }

    public StyleRange(int n2, int n3, int n4, Color color, Color color2, int n5, Color color3, Stroke stroke) {
        this(n2, n3, n4, color, color2, n5, color3, stroke, 1.5f);
    }

    public StyleRange(int n2, int n3, int n4, Color color, int n5, Color color2, Stroke stroke, float f2) {
        this(n2, n3, n4, color, null, n5, color2, stroke, f2);
    }

    public StyleRange(int n2, int n3, int n4, Color color, Color color2, int n5, Color color3, Stroke stroke, float f2) {
        if (n3 == 0) {
            throw new IllegalArgumentException("The length of StyleRange cannot be 0.");
        }
        this._start = n2;
        this._length = n3;
        this._fontColor = color;
        this._fontStyle = n4;
        this._backgroundColor = color2;
        this._lineColor = color3;
        this._lineStroke = stroke;
        this._additionalStyle = n5;
        this._fontShrinkRatio = f2;
    }

    public int getStart() {
        return this._start;
    }

    public int getLength() {
        return this._length;
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public Color getFontColor() {
        return this._fontColor;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public int getAdditionalStyle() {
        return this._additionalStyle;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public Stroke getLineStroke() {
        return this._lineStroke;
    }

    public boolean isStrikethrough() {
        return (this._additionalStyle & 1) != 0;
    }

    public boolean isDoublestrikethrough() {
        return (this._additionalStyle & 2) != 0;
    }

    public boolean isWaved() {
        return (this._additionalStyle & 4) != 0;
    }

    public boolean isUnderlined() {
        return (this._additionalStyle & 8) != 0;
    }

    public boolean isDotted() {
        return (this._additionalStyle & 0x10) != 0;
    }

    public boolean isSuperscript() {
        return (this._additionalStyle & 0x20) != 0;
    }

    public boolean isSubscript() {
        return (this._additionalStyle & 0x40) != 0;
    }

    public float getFontShrinkRatio() {
        return this._fontShrinkRatio;
    }
}

