/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import net.sf.samtools.util.HttpUtils;
import net.sf.samtools.util.SeekableStream;

public class SeekableHTTPStream
extends SeekableStream {
    private long position = 0L;
    private long contentLength = -1L;
    private final URL url;
    private Proxy proxy;

    public SeekableHTTPStream(URL url) {
        this(url, null);
    }

    public SeekableHTTPStream(URL url, Proxy proxy) {
        this.proxy = proxy;
        this.url = url;
        String contentLengthString = HttpUtils.getHeaderField(url, "Content-Length");
        if (contentLengthString != null) {
            try {
                this.contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException ignored) {
                System.err.println("WARNING: Invalid content length (" + contentLengthString + "  for: " + url);
                this.contentLength = -1L;
            }
        }
    }

    public long length() {
        return this.contentLength;
    }

    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    public void seek(long position) {
        this.position = position;
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        HttpURLConnection connection = null;
        InputStream is = null;
        String byteRange = "";
        int n2 = 0;
        try {
            connection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            byteRange = "bytes=" + this.position + "-" + endRange;
            connection.setRequestProperty("Range", byteRange);
            is = connection.getInputStream();
            while (n2 < len) {
                int count = is.read(buffer, offset + n2, len - n2);
                if (count < 0) {
                    if (n2 != 0) break;
                    int n3 = -1;
                    return n3;
                }
                n2 += count;
            }
            this.position += (long)n2;
            int n4 = n2;
            return n4;
        }
        catch (IOException e2) {
            if (e2.getMessage().contains("416") || e2 instanceof EOFException) {
                if (n2 < 0) {
                    int n5 = -1;
                    return n5;
                }
                this.position += (long)n2;
                this.contentLength = this.position;
                int n6 = n2;
                return n6;
            }
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() not support for SeekableHTTPStreams");
    }

    public String getSource() {
        return this.url.toString();
    }
}

