/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractAttrNS
extends AbstractAttr {
    protected String namespaceURI;

    protected AbstractAttrNS() {
    }

    protected AbstractAttrNS(String nsURI, String qname, AbstractDocument owner) throws DOMException {
        super(qname, owner);
        if (nsURI != null && nsURI.length() == 0) {
            nsURI = null;
        }
        this.namespaceURI = nsURI;
        String prefix = DOMUtilities.getPrefix(qname);
        if (!owner.getStrictErrorChecking()) {
            return;
        }
        if (prefix != null ? nsURI == null || "xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(nsURI) || "xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(nsURI) : "xmlns".equals(qname) && !"http://www.w3.org/2000/xmlns/".equals(nsURI)) {
            throw this.createDOMException((short)14, "namespace.uri", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), nsURI});
        }
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    protected Node export(Node n2, AbstractDocument d2) {
        super.export(n2, d2);
        AbstractAttrNS aa = (AbstractAttrNS)n2;
        aa.namespaceURI = this.namespaceURI;
        return n2;
    }

    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        AbstractAttrNS aa = (AbstractAttrNS)n2;
        aa.namespaceURI = this.namespaceURI;
        return n2;
    }

    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        AbstractAttrNS aa = (AbstractAttrNS)n2;
        aa.namespaceURI = this.namespaceURI;
        return n2;
    }

    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        AbstractAttrNS aa = (AbstractAttrNS)n2;
        aa.namespaceURI = this.namespaceURI;
        return n2;
    }
}

