/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.ArrayList;
import org.apache.batik.svggen.SVGStylingAttributes;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGCSSStyler
implements SVGSyntax {
    private static final char CSS_PROPERTY_VALUE_SEPARATOR = ':';
    private static final char CSS_RULE_SEPARATOR = ';';
    private static final char SPACE = ' ';

    public static void style(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Element element = (Element)node;
            StringBuffer styleAttrBuffer = new StringBuffer();
            int nAttr = attributes.getLength();
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            int i2 = 0;
            while (i2 < nAttr) {
                Attr attr = (Attr)attributes.item(i2);
                String attrName = attr.getName();
                if (SVGStylingAttributes.set.contains(attrName)) {
                    styleAttrBuffer.append(attrName);
                    styleAttrBuffer.append(':');
                    styleAttrBuffer.append(attr.getValue());
                    styleAttrBuffer.append(';');
                    styleAttrBuffer.append(' ');
                    toBeRemoved.add(attrName);
                }
                ++i2;
            }
            if (styleAttrBuffer.length() > 0) {
                element.setAttributeNS(null, "style", styleAttrBuffer.toString().trim());
                int n2 = toBeRemoved.size();
                int i3 = 0;
                while (i3 < n2) {
                    element.removeAttribute((String)toBeRemoved.get(i3));
                    ++i3;
                }
            }
        }
        NodeList children = node.getChildNodes();
        int nChildren = children.getLength();
        int i4 = 0;
        while (i4 < nChildren) {
            Node child = children.item(i4);
            SVGCSSStyler.style(child);
            ++i4;
        }
    }
}

