/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Max
extends AbstractStorelessUnivariateStatistic {
    private static final long serialVersionUID = -5593383832225844641L;
    private long n = 0L;
    private double value = Double.NaN;

    public void increment(double d2) {
        if (d2 > this.value || Double.isNaN(this.value)) {
            this.value = d2;
        }
        ++this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public double evaluate(double[] values, int begin, int length) {
        double max = Double.NaN;
        if (this.test(values, begin, length)) {
            max = values[begin];
            int i2 = begin;
            while (i2 < begin + length) {
                if (!Double.isNaN(values[i2])) {
                    max = max > values[i2] ? max : values[i2];
                }
                ++i2;
            }
        }
        return max;
    }
}

