/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Min
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -2941995784909003131L;
    private long n = 0L;
    private double value = Double.NaN;

    public void increment(double d2) {
        if (d2 < this.value || Double.isNaN(this.value)) {
            this.value = d2;
        }
        ++this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public double evaluate(double[] values, int begin, int length) {
        double min = Double.NaN;
        if (this.test(values, begin, length)) {
            min = values[begin];
            int i2 = begin;
            while (i2 < begin + length) {
                if (!Double.isNaN(values[i2])) {
                    min = min < values[i2] ? min : values[i2];
                }
                ++i2;
            }
        }
        return min;
    }
}

