/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

public final class MathUtils {
    private static final byte NB = -1;
    private static final short NS = -1;
    private static final byte PB = 1;
    private static final short PS = 1;
    private static final byte ZB = 0;
    private static final short ZS = 0;

    private MathUtils() {
    }

    public static int addAndCheck(int x, int y) {
        long s = (long)x + (long)y;
        if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)s;
    }

    public static long binomialCoefficient(int n2, int k2) {
        if (n2 < k2) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n,k)");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n,k)");
        }
        if (n2 == k2 || k2 == 0) {
            return 1L;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        long result = Math.round(MathUtils.binomialCoefficientDouble(n2, k2));
        if (result == Long.MAX_VALUE) {
            throw new ArithmeticException("result too large to represent in a long integer");
        }
        return result;
    }

    public static double binomialCoefficientDouble(int n2, int k2) {
        return Math.floor(Math.exp(MathUtils.binomialCoefficientLog(n2, k2)) + 0.5);
    }

    public static double binomialCoefficientLog(int n2, int k2) {
        if (n2 < k2) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n,k)");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n,k)");
        }
        if (n2 == k2 || k2 == 0) {
            return 0.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return Math.log(n2);
        }
        double logSum = 0.0;
        int i2 = k2 + 1;
        while (i2 <= n2) {
            logSum += Math.log(i2);
            ++i2;
        }
        int i3 = 2;
        while (i3 <= n2 - k2) {
            logSum -= Math.log(i3);
            ++i3;
        }
        return logSum;
    }

    public static double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static boolean equals(double x, double y) {
        return Double.isNaN(x) && Double.isNaN(y) || x == y;
    }

    public static long factorial(int n2) {
        long result = Math.round(MathUtils.factorialDouble(n2));
        if (result == Long.MAX_VALUE) {
            throw new ArithmeticException("result too large to represent in a long integer");
        }
        return result;
    }

    public static double factorialDouble(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("must have n >= 0 for n!");
        }
        return Math.floor(Math.exp(MathUtils.factorialLog(n2)) + 0.5);
    }

    public static double factorialLog(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("must have n > 0 for n!");
        }
        double logSum = 0.0;
        int i2 = 2;
        while (i2 <= n2) {
            logSum += Math.log(i2);
            ++i2;
        }
        return logSum;
    }

    public static int gcd(int u, int v) {
        if (u * v == 0) {
            return Math.abs(u) + Math.abs(v);
        }
        if (u > 0) {
            u = -u;
        }
        if (v > 0) {
            v = -v;
        }
        int k2 = 0;
        while ((u & 1) == 0 && (v & 1) == 0 && k2 < 31) {
            u /= 2;
            v /= 2;
            ++k2;
        }
        if (k2 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int t = (u & 1) == 1 ? v : -(u / 2);
        while (true) {
            if ((t & 1) == 0) {
                t /= 2;
                continue;
            }
            if (t > 0) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = (v - u) / 2) == 0) break;
        }
        return -u * (1 << k2);
    }

    public static int hash(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static byte indicator(byte x) {
        return x >= 0 ? (byte)1 : -1;
    }

    public static double indicator(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return x >= 0.0 ? 1.0 : -1.0;
    }

    public static float indicator(float x) {
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        return x >= 0.0f ? 1.0f : -1.0f;
    }

    public static int indicator(int x) {
        return x >= 0 ? 1 : -1;
    }

    public static long indicator(long x) {
        return x >= 0L ? 1L : -1L;
    }

    public static short indicator(short x) {
        return x >= 0 ? (short)1 : -1;
    }

    public static int lcm(int a2, int b2) {
        return Math.abs(MathUtils.mulAndCheck(a2 / MathUtils.gcd(a2, b2), b2));
    }

    public static int mulAndCheck(int x, int y) {
        long m2 = (long)x * (long)y;
        if (m2 < Integer.MIN_VALUE || m2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)m2;
    }

    public static double round(double x, int scale) {
        return MathUtils.round(x, scale, 4);
    }

    public static double round(double x, int scale, int roundingMethod) {
        double sign = MathUtils.indicator(x);
        double factor = Math.pow(10.0, scale) * sign;
        return MathUtils.roundUnscaled(x * factor, sign, roundingMethod) / factor;
    }

    public static float round(float x, int scale) {
        return MathUtils.round(x, scale, 4);
    }

    public static float round(float x, int scale, int roundingMethod) {
        float sign = MathUtils.indicator(x);
        float factor = (float)Math.pow(10.0, scale) * sign;
        return (float)MathUtils.roundUnscaled(x * factor, sign, roundingMethod) / factor;
    }

    private static double roundUnscaled(double unscaled, double sign, int roundingMethod) {
        switch (roundingMethod) {
            case 2: {
                if (sign == -1.0) {
                    unscaled = Math.floor(unscaled);
                    break;
                }
                unscaled = Math.ceil(unscaled);
                break;
            }
            case 1: {
                unscaled = Math.floor(unscaled);
                break;
            }
            case 3: {
                if (sign == -1.0) {
                    unscaled = Math.ceil(unscaled);
                    break;
                }
                unscaled = Math.floor(unscaled);
                break;
            }
            case 5: {
                double fraction = Math.abs(unscaled - Math.floor(unscaled));
                if (fraction > 0.5) {
                    unscaled = Math.ceil(unscaled);
                    break;
                }
                unscaled = Math.floor(unscaled);
                break;
            }
            case 6: {
                double fraction = Math.abs(unscaled - Math.floor(unscaled));
                if (fraction > 0.5) {
                    unscaled = Math.ceil(unscaled);
                    break;
                }
                if (fraction < 0.5) {
                    unscaled = Math.floor(unscaled);
                    break;
                }
                if (Math.floor(unscaled) / 2.0 == Math.floor(Math.floor(unscaled) / 2.0)) {
                    unscaled = Math.floor(unscaled);
                    break;
                }
                unscaled = Math.ceil(unscaled);
                break;
            }
            case 4: {
                double fraction = Math.abs(unscaled - Math.floor(unscaled));
                if (fraction >= 0.5) {
                    unscaled = Math.ceil(unscaled);
                    break;
                }
                unscaled = Math.floor(unscaled);
                break;
            }
            case 7: {
                if (unscaled == Math.floor(unscaled)) break;
                throw new ArithmeticException("Inexact result from rounding");
            }
            case 0: {
                unscaled = Math.ceil(unscaled);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rounding method.");
            }
        }
        return unscaled;
    }

    public static byte sign(byte x) {
        return (byte)(x == 0 ? 0 : (x > 0 ? 1 : -1));
    }

    public static double sign(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return x == 0.0 ? 0.0 : (x > 0.0 ? 1.0 : -1.0);
    }

    public static float sign(float x) {
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        return x == 0.0f ? 0.0f : (x > 0.0f ? 1.0f : -1.0f);
    }

    public static int sign(int x) {
        return x == 0 ? 0 : (x > 0 ? 1 : -1);
    }

    public static long sign(long x) {
        return x == 0L ? 0L : (x > 0L ? 1L : -1L);
    }

    public static short sign(short x) {
        return (short)(x == 0 ? 0 : (x > 0 ? 1 : -1));
    }

    public static double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static int subAndCheck(int x, int y) {
        long s = (long)x - (long)y;
        if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: subtract");
        }
        return (int)s;
    }
}

