/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;

public class Hierarchy
implements LoggerRepository,
RendererSupport {
    private LoggerFactory defaultFactory;
    private Vector listeners;
    Hashtable ht = new Hashtable();
    Logger root;
    RendererMap rendererMap;
    int thresholdInt;
    Level threshold;
    boolean emittedNoAppenderWarning = false;
    boolean emittedNoResourceBundleWarning = false;

    public Hierarchy(Logger root) {
        this.listeners = new Vector(1);
        this.root = root;
        this.setThreshold(Level.ALL);
        this.root.setHierarchy(this);
        this.rendererMap = new RendererMap();
        this.defaultFactory = new DefaultCategoryFactory();
    }

    public void addRenderer(Class classToRender, ObjectRenderer or) {
        this.rendererMap.put(classToRender, or);
    }

    public void addHierarchyEventListener(HierarchyEventListener listener) {
        if (this.listeners.contains(listener)) {
            LogLog.warn("Ignoring attempt to add an existent listener.");
        } else {
            this.listeners.addElement(listener);
        }
    }

    public void clear() {
        this.ht.clear();
    }

    public void emitNoAppenderWarning(Category cat) {
        if (!this.emittedNoAppenderWarning) {
            LogLog.warn("No appenders could be found for logger (" + cat.getName() + ").");
            LogLog.warn("Please initialize the log4j system properly.");
            this.emittedNoAppenderWarning = true;
        }
    }

    public Logger exists(String name) {
        Object o2 = this.ht.get(new CategoryKey(name));
        if (o2 instanceof Logger) {
            return (Logger)o2;
        }
        return null;
    }

    public void setThreshold(String levelStr) {
        Level l = Level.toLevel(levelStr, null);
        if (l != null) {
            this.setThreshold(l);
        } else {
            LogLog.warn("Could not convert [" + levelStr + "] to Level.");
        }
    }

    public void setThreshold(Level l) {
        if (l != null) {
            this.thresholdInt = l.level;
            this.threshold = l;
        }
    }

    public void fireAddAppenderEvent(Category logger, Appender appender) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i2 = 0; i2 < size; ++i2) {
                HierarchyEventListener listener = (HierarchyEventListener)this.listeners.elementAt(i2);
                listener.addAppenderEvent(logger, appender);
            }
        }
    }

    void fireRemoveAppenderEvent(Category logger, Appender appender) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i2 = 0; i2 < size; ++i2) {
                HierarchyEventListener listener = (HierarchyEventListener)this.listeners.elementAt(i2);
                listener.removeAppenderEvent(logger, appender);
            }
        }
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, this.defaultFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name, LoggerFactory factory) {
        CategoryKey key = new CategoryKey(name);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object o2 = this.ht.get(key);
            if (o2 == null) {
                Logger logger = factory.makeNewLoggerInstance(name);
                logger.setHierarchy(this);
                this.ht.put(key, logger);
                this.updateParents(logger);
                return logger;
            }
            if (o2 instanceof Logger) {
                return (Logger)o2;
            }
            if (o2 instanceof ProvisionNode) {
                Logger logger = factory.makeNewLoggerInstance(name);
                logger.setHierarchy(this);
                this.ht.put(key, logger);
                this.updateChildren((ProvisionNode)o2, logger);
                this.updateParents(logger);
                return logger;
            }
            return null;
        }
    }

    public Enumeration getCurrentLoggers() {
        Vector v = new Vector(this.ht.size());
        Enumeration elems = this.ht.elements();
        while (elems.hasMoreElements()) {
            Object o2 = elems.nextElement();
            if (!(o2 instanceof Logger)) continue;
            v.addElement(o2);
        }
        return v.elements();
    }

    public Enumeration getCurrentCategories() {
        return this.getCurrentLoggers();
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Logger getRootLogger() {
        return this.root;
    }

    public boolean isDisabled(int level) {
        return this.thresholdInt > level;
    }

    public void overrideAsNeeded(String override) {
        LogLog.warn("The Hiearchy.overrideAsNeeded method has been deprecated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConfiguration() {
        this.getRootLogger().setLevel(Level.DEBUG);
        this.root.setResourceBundle(null);
        this.setThreshold(Level.ALL);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            this.shutdown();
            Enumeration cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                Logger c2 = (Logger)cats.nextElement();
                c2.setLevel(null);
                c2.setAdditivity(true);
                c2.setResourceBundle(null);
            }
        }
        this.rendererMap.clear();
    }

    public void setDisableOverride(String override) {
        LogLog.warn("The Hiearchy.setDisableOverride method has been deprecated.");
    }

    public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
        this.rendererMap.put(renderedClass, renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Logger root = this.getRootLogger();
        root.closeNestedAppenders();
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Logger c2;
            Enumeration cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                c2 = (Logger)cats.nextElement();
                c2.closeNestedAppenders();
            }
            root.removeAllAppenders();
            cats = this.getCurrentLoggers();
            while (cats.hasMoreElements()) {
                c2 = (Logger)cats.nextElement();
                c2.removeAllAppenders();
            }
        }
    }

    private final void updateParents(Logger cat) {
        String name = cat.name;
        int length = name.length();
        boolean parentFound = false;
        int i2 = name.lastIndexOf(46, length - 1);
        while (i2 >= 0) {
            String substr = name.substring(0, i2);
            CategoryKey key = new CategoryKey(substr);
            Object o2 = this.ht.get(key);
            if (o2 == null) {
                ProvisionNode pn = new ProvisionNode(cat);
                this.ht.put(key, pn);
            } else {
                if (o2 instanceof Category) {
                    parentFound = true;
                    cat.parent = (Category)o2;
                    break;
                }
                if (o2 instanceof ProvisionNode) {
                    ((ProvisionNode)o2).addElement(cat);
                } else {
                    IllegalStateException e2 = new IllegalStateException("unexpected object type " + o2.getClass() + " in ht.");
                    e2.printStackTrace();
                }
            }
            i2 = name.lastIndexOf(46, i2 - 1);
        }
        if (!parentFound) {
            cat.parent = this.root;
        }
    }

    private final void updateChildren(ProvisionNode pn, Logger logger) {
        int last = pn.size();
        for (int i2 = 0; i2 < last; ++i2) {
            Logger l = (Logger)pn.elementAt(i2);
            if (l.parent.name.startsWith(logger.name)) continue;
            logger.parent = l.parent;
            l.parent = logger;
        }
    }
}

