/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.broad.igv.IGVPreferences;
import org.broad.igv.maf.MAFManager;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.AboutDialog;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.ColorTable;
import org.broad.igv.ui.util.PropertyManager;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.IGVHttpUtils;

public class PreferenceManager
implements PropertyManager {
    public static final String DEFAULT_CHART_TRACK_HEIGHT = "40";
    private static Logger log = Logger.getLogger(PreferenceManager.class);
    public static final String TRACK_PROPERTIES_FILE = "TRACK_PROPERTIES_FILE";
    private static final String DEFAULT_PORT_NUMBER = "60151";
    private static final int INITIAL_TRACK_HEIGHT = 15;
    private final String SYSTEM_DEFAULT_FOR_DIRECT_DRAW = System.getProperty("sun.java2d.noddraw");
    public static final String EXPAND_FEAUTRE_TRACKS = "EXPAND_FEATURE_TRACKS";
    public static final String PORT_ENABLED = "PORT_ENABLED";
    public static final String PORT_NUMBER = "PORT_NUMBER";
    public static final String TRACK_PROPERTIES_URL_KEY = "TRACK_PROPERTIES_URL";
    public static final String COLOR_SCALE_KEY = "COLOR_SCALE_";
    public static final String FRAME_BOUNDS_KEY = "IGVMainFrame.Bounds";
    public static final String DRAW_EXON_NUMBERS_KEY = "DRAW_EXON_NUMBERS";
    public static final String RECENT_SESSION_KEY = "IGVMainFrame.Session.recent.sessions";
    public static final String TRACK_HEIGHT_KEY = "IGVMainFrame.track.height";
    public static final String CHART_TRACK_HEIGHT_KEY = "IGVMainFrame.chart.track.height";
    public static final String SHOW_MISSING_DATA_KEY = "IGVMainFrame.track.show.missing.data";
    public static final String SHOW_ATTRIBUTE_VIEWS_KEY = "IGVMainFrame.track.show.attribute.views";
    public static final String SHOW_SINGLE_TRACK_PANE_KEY = "IGVMainFrame.single.track.pane";
    public static final String JOIN_ADJACENT_SEGMENTS_KEY = "IGVMainFrame.join.adjacent.segments";
    public static final String SHOW_REGION_TOOL_KEY = "IGVMainFrame.show.region.tool";
    public static final String SHOW_REGION_BARS = "SHOW_REGION_BARS";
    public static final String LAST_EXPORTED_REGION_DIRECTORY = "LAST_EXPORTED_REGION_DIRECTORY";
    public static final String LAST_TRACK_DIRECTORY = "LAST_TRACK_DIRECTORY";
    public static final String LAST_ATTRIBUTE_FILE_DIRECTORY = "LAST_ATTRIBUTE_FILE_DIRECTORY";
    public static final String LAST_SNAPSHOT_DIRECTORY = "LAST_SNAPSHOT_DIRECTORY";
    public static final String LAST_GENOME_IMPORT_DIRECTORY = "LAST_GENOME_IMPORT_DIRECTORY";
    public static final String LAST_SESSION_DIRECTORY = "LAST_SESSION_DIRECTORY";
    public static final String DEFAULT_GENOME_KEY = "DEFAULT_GENOME_KEY";
    public static final String LAST_CHROMOSOME_VIEWED_KEY = "LAST_CHROMOSOME_VIEWED_KEY";
    public static final String MUTATION_INDEL_COLOR_KEY = "MUTATION_INDEL_COLOR_KEY";
    public static final String MUTATION_MISSENSE_COLOR_KEY = "MUTATION_MISSENSE_COLOR_KEY";
    public static final String MUTATION_NONSENSE_COLOR_KEY = "MUTATION_NONSENSE_COLOR_KEY";
    public static final String MUTATION_SPLICE_SITE_COLOR_KEY = "MUTATION_SPLICE_SITE_COLOR_KEY";
    public static final String MUTATION_SYNONYMOUS_COLOR_KEY = "MUTATION_SYNONYMOUS_COLOR_KEY";
    public static final String MUTATION_TARGETED_REGION_COLOR_KEY = "MUTATION_TARGETED_REGION_COLOR_KEY";
    public static final String MUTATION_UNKNOWN_COLOR_KEY = "MUTATION_UNKNOWN_COLOR_KEY";
    public static final String DIRECT_DRAW_DISABLED_KEY = "DIRECT_DRAW_DISABLED_KEY";
    public static final String OVERLAY_TRACKS_KEY = "OVERLAY_TRACKS_KEY";
    public static final String DISPLAY_OVERLAY_TRACKS_KEY = "DISPLAY_OVERLAY_TRACKS_KEY";
    public static final String OVERLAY_ATTRIBUTE_KEY = "OVERLAY_ATTRIBUTE_KEY";
    public static final String COLOR_OVERLAY_KEY = "COVER_OVERLAY_KEY";
    public static final String ENABLE_LINKED_SORTING = "ENABLE_LINKED_SORTING";
    public static final String TRACK_ATTRIBUTE_NAME_KEY = "TRACK_ATTRIBUTE_NAME_KEY";
    public static final String CHECKED_RESOURCES_KEY = "CHECKED_RESOURCES_KEY";
    public static final String DEFINE_GENOME_INPUT_DIRECTORY_KEY = "DEFINE_GENOME_INPUT_DIRECTORY_KEY";
    public static final String LAST_CYTOBAND_DIRECTORY_KEY = "LAST_CYTOBAND_DIRECTORY_KEY";
    public static final String LAST_REFFLAT_DIRECTORY_KEY = "LAST_REFFLAT_DIRECTORY_KEY";
    public static final String LAST_FASTA_DIRECTORY_KEY = "LAST_FASTA_DIRECTORY_KEY";
    public static final String LAST_SEQUENCE_DIRECTORY_KEY = "LAST_SEQUENCE_DIRECTORY_KEY";
    public static final String MAF_SPECIES_KEY = "MAF_SPECIES_KEY";
    public static final String PROBE_MAPPING_KEY = "PROBE_MAPPING_KEY";
    public static final String SEARCH_ZOOM = "SEARCH_ZOOM";
    public static final String NORMALIZE_COVERAGE = "NORMALIZE_COVERAGE";
    public static final String SHOW_EXPAND_ICON = "SHOW_EXPAND_ICON";
    public static final String SHOW_SIZE_WARNING = "SHOW_SIZE_WARNING";
    public static final String SHOW_GENOME_SERVER_WARNING = "SHOW_GENOME_SERVER_WARNING";
    public static final String USE_PROXY = "PROXY.USE";
    public static final String PROXY_HOST = "PROXY.HOST";
    public static final String PROXY_PORT = "PROXY.PORT";
    public static final String PROXY_AUTHENTICATE = "PROXY.AUTHENTICATE";
    public static final String PROXY_USER = "PROXY.USERNAME";
    public static final String PROXY_PW = "PROXY.PW";
    public static final String KNOWN_SNPS = "KNOWN_SNPS_FILE";
    public static final String USE_BYTE_RANGE = "UseHttpByteRange";
    public static final String DATA_SERVER_URL_KEY = "MASTER_RESOURCE_FILE_KEY";
    public static final String GENOMES_SEQUENCE_URL = "IGVMainFrame.genome.sequence.dir";
    public static String DEFAULT_DATA_SERVER_URL;
    public static String DEFAULT_GENOME_SERVER_URL;
    IGVPreferences preferences;
    private Map<String, String> stringCache = new HashMap<String, String>(1000);
    private Map<String, Boolean> booleanCache = new Hashtable<String, Boolean>();
    private Map<String, Object> objectCache = new Hashtable<String, Object>();
    private Map<TrackType, ContinuousColorScale> colorScaleCache = new Hashtable<TrackType, ContinuousColorScale>();
    private static PreferenceManager instance;
    static Set<String> scaledTypes;

    public static PreferenceManager getInstance() {
        return instance;
    }

    private PreferenceManager() {
        this.preferences = new IGVPreferences();
        if (this.preferences.get("migrated") == null) {
            this.migratePreferences();
        }
    }

    private void migratePreferences() {
        try {
            this.preferences.suspendStorage();
            Preferences oldPreferences = Preferences.userNodeForPackage(PreferenceManager.class);
            for (String key : oldPreferences.keys()) {
                String value = oldPreferences.get(key, null);
                if (value == null) continue;
                this.preferences.put(key, value);
            }
            oldPreferences.clear();
            this.preferences.resumeStorage();
            this.preferences.put("migrated", "true");
        }
        catch (BackingStoreException e2) {
            log.error("Error migrating preferences", e2);
        }
    }

    public void mergePreferences(Map<String, String> newPrefs) {
        for (Map.Entry<String, String> entry : newPrefs.entrySet()) {
            String key = entry.getKey();
            if (newPrefs.containsKey(key)) continue;
            this.put(key, entry.getValue());
        }
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        Boolean boolValue = this.booleanCache.get(key);
        if (boolValue == null) {
            String value = this.get(key, null);
            boolValue = value != null && !value.trim().equals("") ? new Boolean(value) : new Boolean(defaultValue);
            this.booleanCache.put(key, boolValue);
        }
        return boolValue;
    }

    public boolean isMapProbesToGenes() {
        return this.getBooleanPreference(PROBE_MAPPING_KEY, false);
    }

    public boolean isShowRegionBars() {
        return this.getBooleanPreference(SHOW_REGION_BARS, false);
    }

    public void setShowRegionBars(boolean show) {
        this.put(SHOW_REGION_BARS, String.valueOf(show));
    }

    public boolean isJoinAdjacentSegments() {
        return this.getBooleanPreference(JOIN_ADJACENT_SEGMENTS_KEY, false);
    }

    public boolean isUseByteRange() {
        return this.getBooleanPreference(USE_BYTE_RANGE, true);
    }

    private void updateCaches(String key, String value) {
        this.stringCache.put(key, value);
        if (this.booleanCache.containsKey(key)) {
            this.booleanCache.put(key, new Boolean(value));
        }
        this.objectCache.remove(key);
    }

    private void clearCaches() {
        this.stringCache.clear();
        this.booleanCache.clear();
        this.objectCache.clear();
    }

    @Override
    public void put(String key, String value) {
        this.preferences.put(key, value);
        this.updateCaches(key, value);
    }

    public void putAll(Map<String, String> updatedPrefs) {
        for (Map.Entry<String, String> entry : updatedPrefs.entrySet()) {
            if (entry.getValue() == null || entry.getValue().trim().length() == 0) {
                this.remove(entry.getKey());
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
        this.clearCaches();
    }

    @Override
    public String get(String key, String defaultString) {
        String rtn = this.stringCache.get(key);
        if (rtn == null) {
            rtn = this.preferences.get(key, defaultString);
            this.stringCache.put(key, rtn);
        }
        return rtn;
    }

    @Override
    public void remove(String key) {
        this.preferences.remove(key);
        this.stringCache.remove(key);
        this.booleanCache.remove(key);
        this.objectCache.clear();
    }

    public void clear() {
        this.preferences.clear();
        this.stringCache.clear();
        this.booleanCache.clear();
        this.objectCache.clear();
        Preferences oldPreferences = Preferences.userNodeForPackage(PreferenceManager.class);
        try {
            oldPreferences.clear();
        }
        catch (BackingStoreException e2) {
            log.error("Error clearing preferences store: ", e2);
        }
    }

    public String getGenomeListURL() {
        return this.get(GENOMES_SEQUENCE_URL, DEFAULT_GENOME_SERVER_URL);
    }

    public boolean getOverlayTracks() {
        return this.getBooleanPreference(OVERLAY_TRACKS_KEY, true);
    }

    public void setOverlayTracks(boolean value) {
        this.put(OVERLAY_TRACKS_KEY, String.valueOf(value));
    }

    public List<String> getMafSpecies() {
        String tmp = this.get(MAF_SPECIES_KEY, null);
        String[] species = null;
        species = tmp == null ? MAFManager.species : tmp.split(":");
        return Arrays.asList(species);
    }

    public void setMafSpecies(List<String> species) {
        StringBuffer buf = new StringBuffer(species.size() * 7);
        Iterator<String> iter = species.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(":");
        }
        this.put(MAF_SPECIES_KEY, buf.toString());
    }

    public boolean getColorOverlay() {
        return this.getBooleanPreference(COLOR_OVERLAY_KEY, false);
    }

    public boolean getDiplayOverlayTracks() {
        return this.getBooleanPreference(DISPLAY_OVERLAY_TRACKS_KEY, true);
    }

    public void setDirectDrawDisabled(boolean value) {
        if (value) {
            System.setProperty("sun.java2d.noddraw", "true");
        } else if (System.getProperty("sun.java2d.noddraw") != null) {
            System.clearProperty("sun.java2d.noddraw");
        }
        this.put(DIRECT_DRAW_DISABLED_KEY, String.valueOf(value));
    }

    public String getOverlayAttribute() {
        return this.get(OVERLAY_ATTRIBUTE_KEY, "LINKING_ID");
    }

    public boolean isLinkedSortingEnabled() {
        return this.getBooleanPreference(ENABLE_LINKED_SORTING, true);
    }

    public void setLinkedSortingEnabled(boolean value) {
        this.put(ENABLE_LINKED_SORTING, Boolean.toString(value));
    }

    public String getCheckedResources() {
        return this.preferences.get(CHECKED_RESOURCES_KEY, null);
    }

    public void setCheckedResources(String value) {
        this.preferences.put(CHECKED_RESOURCES_KEY, value);
    }

    public boolean getShowSingleTrackPane() {
        return this.getBooleanPreference(SHOW_SINGLE_TRACK_PANE_KEY, false);
    }

    public void setApplicationFrameBounds(Rectangle bounds) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bounds.x);
        buffer.append(",");
        buffer.append(bounds.y);
        buffer.append(",");
        buffer.append(bounds.width);
        buffer.append(",");
        buffer.append(bounds.height);
        this.put(FRAME_BOUNDS_KEY, buffer.toString());
    }

    public Rectangle getApplicationFrameBounds() {
        Rectangle bounds = null;
        String applicationBounds = this.preferences.get(FRAME_BOUNDS_KEY, null);
        if (applicationBounds != null) {
            String[] values = applicationBounds.split(",");
            int x = Integer.parseInt(values[0]);
            int y = Integer.parseInt(values[1]);
            int width = Integer.parseInt(values[2]);
            int height = Integer.parseInt(values[3]);
            bounds = new Rectangle(x, y, width, height);
        }
        return bounds;
    }

    public void setLastExportedRegionDirectory(File directory) {
        this.put(LAST_EXPORTED_REGION_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastExportedRegionDirectory() {
        File exportedRegionDirectory = null;
        String lastFilePath = this.get(LAST_EXPORTED_REGION_DIRECTORY, null);
        if (lastFilePath != null) {
            exportedRegionDirectory = new File(lastFilePath);
        }
        return exportedRegionDirectory;
    }

    public void setLastSnapshotDirectory(File directory) {
        this.put(LAST_SNAPSHOT_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastSnapshotDirectory() {
        File snapshotDirectory = null;
        String lastFilePath = this.get(LAST_SNAPSHOT_DIRECTORY, null);
        if (lastFilePath != null) {
            snapshotDirectory = new File(lastFilePath);
        }
        return snapshotDirectory;
    }

    public void setDefineGenomeInputDirectory(File directory) {
        this.put(DEFINE_GENOME_INPUT_DIRECTORY_KEY, directory.getAbsolutePath());
    }

    public File getDefineGenomeInputDirectory() {
        File directory = null;
        String lastFilePath = this.get(DEFINE_GENOME_INPUT_DIRECTORY_KEY, UIConstants.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastGenomeImportDirectory(File directory) {
        this.put(LAST_GENOME_IMPORT_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastGenomeImportDirectory() {
        File genomeImportDirectory = null;
        String lastFilePath = this.get(LAST_GENOME_IMPORT_DIRECTORY, UIConstants.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            genomeImportDirectory = new File(lastFilePath);
        }
        return genomeImportDirectory;
    }

    public void setLastCytobandDirectory(File directory) {
        if (directory != null) {
            this.put(LAST_CYTOBAND_DIRECTORY_KEY, directory.getAbsolutePath());
        }
    }

    public File getLastCytobandDirectory() {
        File directory = null;
        String lastFilePath = this.get(LAST_CYTOBAND_DIRECTORY_KEY, UIConstants.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastRefFlatDirectory(File directory) {
        if (directory != null) {
            this.put(LAST_REFFLAT_DIRECTORY_KEY, directory.getAbsolutePath());
        }
    }

    public File getLastRefFlatDirectory() {
        File directory = null;
        String lastFilePath = this.get(LAST_REFFLAT_DIRECTORY_KEY, UIConstants.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastFastaDirectory(File directory) {
        if (directory != null) {
            this.put(LAST_FASTA_DIRECTORY_KEY, directory.getAbsolutePath());
        }
    }

    public File getLastFastaDirectory() {
        File directory = null;
        String lastFilePath = this.get(LAST_FASTA_DIRECTORY_KEY, UIConstants.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastSequenceDirectory(File directory) {
        if (directory != null) {
            this.put(LAST_SEQUENCE_DIRECTORY_KEY, directory.getAbsolutePath());
        }
    }

    public File getLastSequenceDirectory() {
        File directory = null;
        String lastFilePath = this.get(LAST_SEQUENCE_DIRECTORY_KEY, UIConstants.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastSessionDirectory(File directory) {
        this.put(LAST_SESSION_DIRECTORY, directory.getAbsolutePath());
    }

    public File getLastSessionDirectory() {
        File sessionDirectory = null;
        String lastFilePath = this.get(LAST_SESSION_DIRECTORY, null);
        if (lastFilePath != null) {
            sessionDirectory = new File(lastFilePath);
        }
        return sessionDirectory;
    }

    public boolean getShowRegionTool() {
        return this.getBooleanPreference(SHOW_REGION_TOOL_KEY, true);
    }

    public void setRecentSessions(String recentSessions) {
        this.put(RECENT_SESSION_KEY, recentSessions);
    }

    public String getRecentSessions() {
        return this.get(RECENT_SESSION_KEY, null);
    }

    public void setDataServerURL(String masterResourceFile) {
        this.put(DATA_SERVER_URL_KEY, masterResourceFile);
    }

    public int getPortNumber() {
        try {
            return Integer.parseInt(this.get(PORT_NUMBER, DEFAULT_PORT_NUMBER));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(DEFAULT_PORT_NUMBER);
        }
    }

    public boolean isPortEnabled() {
        return this.getBooleanPreference(PORT_ENABLED, true);
    }

    public boolean isExpandTracks() {
        return this.getBooleanPreference(EXPAND_FEAUTRE_TRACKS, false);
    }

    public String getDataServerURL() {
        String masterResourceFile = this.get(DATA_SERVER_URL_KEY, DEFAULT_DATA_SERVER_URL);
        return masterResourceFile;
    }

    public void setShowRegionTool(boolean value) {
        this.put(SHOW_REGION_TOOL_KEY, Boolean.toString(value));
    }

    public void setShowAttributeView(boolean isShowable) {
        this.put(SHOW_ATTRIBUTE_VIEWS_KEY, Boolean.toString(isShowable));
    }

    public boolean getShowAttributeView() {
        return this.getBooleanPreference(SHOW_ATTRIBUTE_VIEWS_KEY, true);
    }

    public boolean getShowMissingData() {
        return this.getBooleanPreference(SHOW_MISSING_DATA_KEY, false);
    }

    public boolean isShowSingleTrackPane() {
        String showSingleTrackPane = PreferenceManager.getInstance().get(SHOW_SINGLE_TRACK_PANE_KEY, "false");
        return Boolean.parseBoolean(showSingleTrackPane);
    }

    public void setLastChromosomeViewed(String chromosome) {
        this.put(LAST_CHROMOSOME_VIEWED_KEY, chromosome);
    }

    public String getLastChromosomeViewed() {
        String chromosome = this.get(LAST_CHROMOSOME_VIEWED_KEY, "chr1");
        return chromosome;
    }

    public void setTrackAttributeName(String attributeName) {
        this.put(TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }

    public String getTrackAttributeName() {
        return this.get(TRACK_ATTRIBUTE_NAME_KEY, "Sample");
    }

    public void setTrackPropertiesURL(String url) {
        this.put(TRACK_PROPERTIES_URL_KEY, url);
    }

    public String getTrackPropertiesURL() {
        return this.get(TRACK_PROPERTIES_URL_KEY, null);
    }

    public void setTrackPropertiesFile(String file) {
        this.put(TRACK_PROPERTIES_FILE, file);
    }

    public String getTrackPropertiesFile() {
        return this.get(TRACK_PROPERTIES_FILE, null);
    }

    public void setDefaultGenome(String genomeId) {
        this.put(DEFAULT_GENOME_KEY, genomeId);
    }

    public String getDefaultGenome() {
        String genome = this.get(DEFAULT_GENOME_KEY, null);
        return genome;
    }

    public void setLastTrackDirectory(File directory) {
        String lastDirectory = directory.getAbsolutePath();
        this.put(LAST_TRACK_DIRECTORY, lastDirectory);
    }

    public File getLastTrackDirectory() {
        String lastDirectoryPath = this.get(LAST_TRACK_DIRECTORY, null);
        File lastDirectoryFile = null;
        if (lastDirectoryPath != null) {
            lastDirectoryFile = new File(lastDirectoryPath);
        }
        return lastDirectoryFile;
    }

    public void setLastAttributeDirectory(File directory) {
        String lastDirectory = directory.getAbsolutePath();
        this.put(LAST_ATTRIBUTE_FILE_DIRECTORY, lastDirectory);
    }

    public File getLastAttributeDirectory() {
        String lastDirectoryPath = this.get(LAST_ATTRIBUTE_FILE_DIRECTORY, null);
        File lastDirectoryFile = null;
        if (lastDirectoryPath != null) {
            lastDirectoryFile = new File(lastDirectoryPath);
        }
        return lastDirectoryFile;
    }

    public int getDefaultTrackHeight() {
        String key = TRACK_HEIGHT_KEY;
        Number val = (Number)this.objectCache.get(key);
        if (val == null) {
            val = new Double(this.get(key, String.valueOf(15)));
            this.objectCache.put(key, val);
        }
        return val.intValue();
    }

    public int getDefaultChartTrackHeight() {
        String key = CHART_TRACK_HEIGHT_KEY;
        Number val = (Number)this.objectCache.get(key);
        if (val == null) {
            val = new Double(this.get(key, DEFAULT_CHART_TRACK_HEIGHT));
            this.objectCache.put(key, val);
        }
        return val.intValue();
    }

    public void setColorScaleString(TrackType type, String colorScaleString) {
        this.put(COLOR_SCALE_KEY + type.toString(), colorScaleString);
        this.colorScaleCache.remove((Object)type);
    }

    public void setColorScale(TrackType type, ContinuousColorScale colorScale) {
        String colorScaleString = colorScale.asString();
        this.put(COLOR_SCALE_KEY + type.toString(), colorScaleString);
        this.colorScaleCache.put(type, colorScale);
    }

    public ContinuousColorScale getColorScale(TrackType type) {
        String colorScaleString;
        if (type == null) {
            return null;
        }
        ContinuousColorScale scale = this.colorScaleCache.get((Object)type);
        if (scale == null && scaledTypes.contains((Object)type) && (scale = (colorScaleString = this.get(COLOR_SCALE_KEY + type.toString(), null)) != null ? (ContinuousColorScale)ColorScaleFactory.getScaleFromString(colorScaleString) : this.getDefaultColorScale(type)) != null) {
            scale.setDefault(true);
            this.colorScaleCache.put(type, scale);
        }
        return scale;
    }

    public ContinuousColorScale getDefaultColorScale(TrackType type) {
        switch (type) {
            case LOH: {
                return new ContinuousColorScale(0.0, -1.0, 0.0, 1.0, Color.red, UIConstants.LIGHT_YELLOW, Color.blue);
            }
            case RNAI: 
            case POOLED_RNAI: {
                ContinuousColorScale cs = new ContinuousColorScale(0.0, -3.0, 0.0, 3.0, Color.red, Color.white, Color.blue);
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case DNA_METHYLATION: {
                ContinuousColorScale cs = new ContinuousColorScale(0.4, 1.0, Color.WHITE, Color.GREEN.darker());
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case GENE_EXPRESSION: {
                ContinuousColorScale cs = new ContinuousColorScale(-0.1, -1.5, 0.1, 1.5, Color.BLUE, Color.WHITE, Color.RED);
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case COPY_NUMBER: 
            case ALLELE_SPECIFIC_COPY_NUMBER: 
            case CNV: {
                return new ContinuousColorScale(-0.1, -1.5, 0.1, 1.5, Color.BLUE, Color.WHITE, Color.RED);
            }
        }
        return null;
    }

    public void setMutationColorScheme(ColorTable colorScheme) {
        this.setMutationColorScheme(UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Indel")), UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Missense")), UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Nonsense")), UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Splice_site")), UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Synonymous")), UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Targeted_Region")), UIUtilities.getcommaSeparatedRGBString(colorScheme.get("Unknown")));
    }

    public void setMutationColorScheme(String indel, String missense, String nonsense, String spliceSite, String synonymous, String targetedRegion, String unknown) {
        this.put(MUTATION_INDEL_COLOR_KEY, indel);
        this.put(MUTATION_MISSENSE_COLOR_KEY, missense);
        this.put(MUTATION_NONSENSE_COLOR_KEY, nonsense);
        this.put(MUTATION_SPLICE_SITE_COLOR_KEY, spliceSite);
        this.put(MUTATION_SYNONYMOUS_COLOR_KEY, synonymous);
        this.put(MUTATION_TARGETED_REGION_COLOR_KEY, targetedRegion);
        this.put(MUTATION_UNKNOWN_COLOR_KEY, unknown);
    }

    public ColorTable getMutationColorScheme() {
        String indelColor = this.get(MUTATION_INDEL_COLOR_KEY, null);
        String missenseColor = this.get(MUTATION_MISSENSE_COLOR_KEY, null);
        String nonsenseColor = this.get(MUTATION_NONSENSE_COLOR_KEY, null);
        String spliceSiteColor = this.get(MUTATION_SPLICE_SITE_COLOR_KEY, null);
        String synonymousColor = this.get(MUTATION_SYNONYMOUS_COLOR_KEY, null);
        String targetedRegionColor = this.get(MUTATION_TARGETED_REGION_COLOR_KEY, null);
        String unknownColor = this.get(MUTATION_UNKNOWN_COLOR_KEY, null);
        ColorTable colorTable = new ColorTable();
        if (indelColor != null && missenseColor != null && nonsenseColor != null && spliceSiteColor != null && synonymousColor != null && targetedRegionColor != null && unknownColor != null) {
            String[] rgb = indelColor.split(",");
            Color color1 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Indel", color1);
            rgb = missenseColor.split(",");
            Color color2 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Missense", color2);
            rgb = nonsenseColor.split(",");
            Color color3 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Nonsense", color3);
            rgb = spliceSiteColor.split(",");
            Color color4 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Splice_site", color4);
            rgb = synonymousColor.split(",");
            Color color5 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Synonymous", color5);
            rgb = targetedRegionColor.split(",");
            Color color6 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Targeted_Region", color6);
            rgb = unknownColor.split(",");
            Color color7 = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            colorTable.put("Unknown", color7);
        }
        return colorTable;
    }

    public ChartPreferences getChartPreferences() {
        ChartPreferences prefs = (ChartPreferences)this.objectCache.get(ChartPreferences.class.getName());
        if (prefs == null) {
            prefs = new ChartPreferences();
            this.objectCache.put(ChartPreferences.class.getName(), prefs);
        }
        prefs.setDrawTopBorder(this.getBooleanPreference("CHART.DRAW_TOP_BORDER", false));
        prefs.setDrawBottomBorder(this.getBooleanPreference("CHART.DRAW_BOTTOM_BORDER", false));
        prefs.setColorBorders(this.getBooleanPreference("CHART.COLOR_BORDERS", true));
        prefs.setDrawAxis(this.getBooleanPreference("CHART.DRAW_AXIS", false));
        prefs.setDrawTrackName(this.getBooleanPreference("CHART.DRAW_TRACK_NAME", false));
        prefs.setColorTrackName(this.getBooleanPreference("CHART.COLOR_TRACK_NAME", true));
        prefs.setAutoscale(this.getBooleanPreference("CHART.AUTOSCALE", true));
        prefs.setShowDataRange(this.getBooleanPreference("CHART.SHOW_DATA_RANGE", true));
        return prefs;
    }

    public void clearProxySettings() {
        this.remove(USE_PROXY);
        this.remove(PROXY_HOST);
        this.remove(PROXY_PORT);
        this.remove(PROXY_AUTHENTICATE);
        this.remove(PROXY_USER);
        this.remove(PROXY_PW);
        IGVHttpUtils.updateProxySettings();
    }

    public SAMPreferences getSAMPreferences() {
        SAMPreferences prefs = (SAMPreferences)this.objectCache.get(SAMPreferences.class.getName());
        if (prefs == null) {
            prefs = new SAMPreferences();
            this.objectCache.put(SAMPreferences.class.getName(), prefs);
            prefs.setMaxVisibleRange(Float.parseFloat(this.get("SAM.MAX_VISIBLE_RANGE", "30")));
            prefs.setShowDuplicates(this.getBooleanPreference("SAM.SHOW_DUPLICATES", false));
            prefs.setShowSoftClipped(this.getBooleanPreference("SAM.SHOW_SOFT_CLIPPED", false));
            prefs.setQualityThreshold(Integer.parseInt(this.get("SAM.QUALITY_THRESHOLD", "0")));
            prefs.setInsertSizeThreshold(Integer.parseInt(this.get("SAM.INSERT_SIZE_THRESHOLD", "10000")));
            prefs.setFlagUnmappedPair(this.getBooleanPreference("SAM.FLAG_UNMAPPED_PAIR", false));
            prefs.setAutosort(this.getBooleanPreference("SAM.AUTOSORT", false));
            prefs.setShadeCenter(this.getBooleanPreference("SAM.SHADE_CENTER", true));
            prefs.setShowRefSequence(this.getBooleanPreference("SAM.SHOW_REF_SEQ", false));
            prefs.setShowCoverageTrack(this.getBooleanPreference("SAM.SHOW_COV_TRACK", true));
            prefs.setMaxLevels(this.getIntegerPreference("SAM.MAX_LEVELS", 100));
            prefs.setMaxReads(this.getIntegerPreference("SAM.MAX_READS", 500000));
            prefs.setShadeBaseQuality(this.getBooleanPreference("SAM.SHADE_BASE_QUALITY", true));
            prefs.setBaseQualityMin(this.getIntegerPreference("SAM.BASE_QUALITY_MIN", 5));
            prefs.setBaseQualityMax(this.getIntegerPreference("SAM.BASE_QUALITY_MAX", 20));
            prefs.setFilterAlignments(this.getBooleanPreference("SAM.FILTER_ALIGNMENTS", false));
            prefs.setFilterFailedReads(this.getBooleanPreference("SAM.FILTER_FAILED_READS", true));
            prefs.setAlleleFreqThreshold(Float.parseFloat(this.get("SAM.ALLELE_THRESHOLD", "0.2f")));
            prefs.setFilterURL(this.get("SAM.FILTER_URL", null));
            prefs.setColorBy(this.get("SAM.COLOR_BY", null));
        }
        return prefs;
    }

    public void updateSAMPreferences() {
        this.objectCache.remove(SAMPreferences.class.getName());
    }

    public int getIntegerPreference(String key, int def) {
        try {
            String prefString = this.get(key, null);
            if (prefString != null) {
                return Integer.parseInt(prefString);
            }
        }
        catch (Exception e2) {
            log.error("Number format error for preference: " + key);
        }
        return def;
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(AboutDialog.class.getResourceAsStream("/resources/about.properties"));
            DEFAULT_DATA_SERVER_URL = properties.getProperty("master-resource-url", "http://www.broadinstitute.org/igvdata/$$_dataServerRegistry.txt");
            if (DEFAULT_DATA_SERVER_URL.equals("@DEFAULT_MASTER_RESOURCE_URL")) {
                DEFAULT_DATA_SERVER_URL = "http://www.broadinstitute.org/igvdata/$$_dataServerRegistry.txt";
            }
            if ((DEFAULT_GENOME_SERVER_URL = properties.getProperty("master-genome-url", "http://igv.broadinstitute.org/genomes/genomes.txt")).equals("@DEFAULT_MASTER_GENOME_URL")) {
                DEFAULT_GENOME_SERVER_URL = "http://igv.broadinstitute.org/genomes/genomes.txt";
            }
        }
        catch (IOException e2) {
            DEFAULT_DATA_SERVER_URL = "http://www.broadinstitute.org/igvdata/$$_dataServerRegistry.txt";
            DEFAULT_GENOME_SERVER_URL = "http://igv.broadinstitute.org/genomes/genomes.txt";
        }
        instance = new PreferenceManager();
        scaledTypes = new HashSet<TrackType>(Arrays.asList(TrackType.LOH, TrackType.RNAI, TrackType.POOLED_RNAI, TrackType.DNA_METHYLATION, TrackType.GENE_EXPRESSION, TrackType.COPY_NUMBER, TrackType.ALLELE_SPECIFIC_COPY_NUMBER, TrackType.CNV));
    }

    public static class SAMPreferences {
        public static final String MAX_VISIBLE_RANGE = "SAM.MAX_VISIBLE_RANGE";
        public static final String SHOW_ZERO_QUALITY = "SAM.SHOW_VISIBLE_QUALITY";
        public static final String SHOW_DUPLICATES = "SAM.SHOW_DUPLICATES";
        public static final String SHOW_SOFT_CLIPPED = "SAM.SHOW_SOFT_CLIPPED";
        public static final String FLAG_UNMAPPED_PAIR = "SAM.FLAG_UNMAPPED_PAIR";
        public static final String MAX_LEVELS = "SAM.MAX_LEVELS";
        public static final String MAX_READS = "SAM.MAX_READS";
        public static final String ALLELE_THRESHOLD = "SAM.ALLELE_THRESHOLD";
        public static final String QUALITY_THRESHOLD = "SAM.QUALITY_THRESHOLD";
        public static final String INSERT_SIZE_THRESHOLD = "SAM.INSERT_SIZE_THRESHOLD";
        public static final String AUTO_SORT = "SAM.AUTOSORT";
        public static final String SHADE_CENTER = "SAM.SHADE_CENTER";
        public static final String SHOW_REF_SEQ = "SAM.SHOW_REF_SEQ";
        public static final String SHOW_COV_TRACK = "SAM.SHOW_COV_TRACK";
        public static final String SHADE_BASE_QUALITY = "SAM.SHADE_BASE_QUALITY";
        public static final String BASE_QUALITY_MIN = "SAM.BASE_QUALITY_MIN";
        public static final String BASE_QUALITY_MAX = "SAM.BASE_QUALITY_MAX";
        public static final String FILTER_ALIGNMENTS = "SAM.FILTER_ALIGNMENTS";
        public static final String FILTER_URL = "SAM.FILTER_URL";
        public static final String COLOR_BY = "SAM.COLOR_BY";
        public static final String FILTER_FAILED_READS = "SAM.FILTER_FAILED_READS";
        private boolean filterAlignments = false;
        private boolean filterFailedReads = true;
        private String filterURL;
        private float maxVisibleRange;
        private int maxLevels = 100;
        private int maxReads = 500000;
        private int qualityThreshold;
        private boolean showDuplicates;
        private boolean flagUnmappedPair;
        private boolean autosort;
        private boolean shadeBaseQuality;
        private int insertSizeThreshold;
        private int baseQualityMin = 0;
        private int baseQualityMax = 40;
        private boolean showRefSequenceFlag;
        private boolean showCoverageTrack;
        private boolean shadeCenterFlag;
        private float alleleFreqThreshold = 0.2f;
        private String colorBy = "INSERT_SIZE";
        private boolean showSoftClipped = false;

        public float getMaxVisibleRange() {
            return this.maxVisibleRange;
        }

        public void setMaxVisibleRange(float maxVisibleRange) {
            this.maxVisibleRange = maxVisibleRange;
        }

        public boolean isShowDuplicates() {
            return this.showDuplicates;
        }

        public void setShowDuplicates(boolean showDuplicates) {
            this.showDuplicates = showDuplicates;
        }

        public boolean isFlagUnmappedPair() {
            return this.flagUnmappedPair;
        }

        public void setFlagUnmappedPair(boolean flagUnmappedPair) {
            this.flagUnmappedPair = flagUnmappedPair;
        }

        public boolean isAutosort() {
            return this.autosort;
        }

        public void setAutosort(boolean autosort) {
            this.autosort = autosort;
        }

        public int getMaxLevels() {
            return this.maxLevels;
        }

        public void setMaxLevels(int maxLevels) {
            this.maxLevels = maxLevels;
        }

        public int getQualityThreshold() {
            return this.qualityThreshold;
        }

        public void setQualityThreshold(int qualityThreshold) {
            this.qualityThreshold = qualityThreshold;
        }

        public int getInsertSizeThreshold() {
            return this.insertSizeThreshold;
        }

        public void setInsertSizeThreshold(int insertSizeThreshold) {
            this.insertSizeThreshold = insertSizeThreshold;
        }

        public boolean isShadeBaseQuality() {
            return this.shadeBaseQuality;
        }

        public void setShadeBaseQuality(boolean shadeBaseQuality) {
            this.shadeBaseQuality = shadeBaseQuality;
        }

        public int getBaseQualityMin() {
            return this.baseQualityMin;
        }

        public void setBaseQualityMin(int baseQualityMin) {
            this.baseQualityMin = baseQualityMin;
        }

        public int getBaseQualityMax() {
            return this.baseQualityMax;
        }

        public void setBaseQualityMax(int baseQualityMax) {
            this.baseQualityMax = baseQualityMax;
        }

        public boolean isShowRefSequence() {
            return this.showRefSequenceFlag;
        }

        public void setShowRefSequence(boolean flag) {
            this.showRefSequenceFlag = flag;
        }

        public boolean isShadeCenter() {
            return this.shadeCenterFlag;
        }

        public void setShadeCenter(boolean flag) {
            this.shadeCenterFlag = flag;
        }

        public boolean isShowCoverageTrack() {
            return this.showCoverageTrack;
        }

        public void setShowCoverageTrack(boolean showCoverageTrack) {
            this.showCoverageTrack = showCoverageTrack;
        }

        public boolean isFilterAlignments() {
            return this.filterAlignments;
        }

        public void setFilterAlignments(boolean filterAlignments) {
            this.filterAlignments = filterAlignments;
        }

        public String getFilterURL() {
            return this.filterURL;
        }

        public void setFilterURL(String filterURL) {
            this.filterURL = filterURL;
        }

        public int getMaxReads() {
            return this.maxReads;
        }

        public void setMaxReads(int maxReads) {
            this.maxReads = maxReads;
        }

        public float getAlleleFreqThreshold() {
            return this.alleleFreqThreshold;
        }

        public void setAlleleFreqThreshold(float alleleFreqThreshold) {
            this.alleleFreqThreshold = alleleFreqThreshold;
        }

        public String getColorBy() {
            return this.colorBy;
        }

        public void setColorBy(String colorBy) {
            this.colorBy = colorBy;
        }

        public boolean isFilterFailedReads() {
            return this.filterFailedReads;
        }

        public void setFilterFailedReads(boolean filterFailedReads) {
            this.filterFailedReads = filterFailedReads;
        }

        public boolean isShowSoftClipped() {
            return this.showSoftClipped;
        }

        public void setShowSoftClipped(boolean showSoftClipped) {
            this.showSoftClipped = showSoftClipped;
        }
    }

    public static class ChartPreferences {
        public static final String DRAW_TOP_BORDER = "CHART.DRAW_TOP_BORDER";
        public static final String DRAW_BOTTOM_BORDER = "CHART.DRAW_BOTTOM_BORDER";
        public static final String COLOR_BORDERS = "CHART.COLOR_BORDERS";
        public static final String Y_AXIS = "CHART.DRAW_AXIS";
        public static final String DRAW_TRACK_NAME = "CHART.DRAW_TRACK_NAME";
        public static final String COLOR_TRACK_NAME = "CHART.COLOR_TRACK_NAME";
        public static final String AUTOSCALE = "CHART.AUTOSCALE";
        public static final String SHOW_DATA_RANGE = "CHART.SHOW_DATA_RANGE";
        private boolean drawTopBorder;
        private boolean drawBottomBorder;
        private boolean colorBorders;
        private boolean drawAxis;
        private boolean drawTrackName;
        private boolean colorTrackName;
        private boolean autoscale;
        private boolean showDataRange;

        public boolean isDrawTopBorder() {
            return this.drawTopBorder;
        }

        public void setDrawTopBorder(boolean drawBorders) {
            this.drawTopBorder = drawBorders;
        }

        public boolean isColorBorders() {
            return this.colorBorders;
        }

        public void setColorBorders(boolean colorBorders) {
            this.colorBorders = colorBorders;
        }

        public boolean isDrawAxis() {
            return this.drawAxis;
        }

        public void setDrawAxis(boolean drawAxis) {
            this.drawAxis = drawAxis;
        }

        public boolean isDrawBottomBorder() {
            return this.drawBottomBorder;
        }

        public void setDrawBottomBorder(boolean drawBottomBorder) {
            this.drawBottomBorder = drawBottomBorder;
        }

        public boolean isDrawTrackName() {
            return this.drawTrackName;
        }

        public void setDrawTrackName(boolean drawTrackName) {
            this.drawTrackName = drawTrackName;
        }

        public boolean isColorTrackName() {
            return this.colorTrackName;
        }

        public void setColorTrackName(boolean colorTrackName) {
            this.colorTrackName = colorTrackName;
        }

        public boolean isAutoscale() {
            return this.autoscale;
        }

        public void setAutoscale(boolean autoscale) {
            this.autoscale = autoscale;
        }

        public boolean isShowDataRange() {
            return this.showDataRange;
        }

        public void setShowDataRange(boolean showDataRange) {
            this.showDataRange = showDataRange;
        }
    }
}

