/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.data.SummaryTile;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tdf.Bin;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.LRUCache;

public abstract class AbstractDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(AbstractDataSource.class);
    boolean cacheSummaryTiles = true;
    WindowFunction windowFunction = WindowFunction.mean;
    LRUCache<String, SummaryTile> summaryTileCache = new LRUCache(this, 10);
    static List<WindowFunction> wfs = new ArrayList<WindowFunction>();

    protected abstract int getNumZoomLevels(String var1);

    protected abstract DataTile getRawData(String var1, int var2, int var3);

    protected List<SummaryTile> getPrecomputedSummaryTiles(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    public int getChrLength(String chr) {
        return ViewContext.getInstance().getChromosomeLength();
    }

    @Override
    public void refreshData(long timestamp) {
    }

    public abstract int getLongestFeature(String var1);

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        List<SummaryTile> tiles = this.getSummaryTilesForRange(chr, startLocation, endLocation, zoom);
        ArrayList<LocusScore> summaryScores = new ArrayList<LocusScore>(tiles.size() * 700);
        for (SummaryTile tile : tiles) {
            summaryScores.addAll(tile.getScores());
        }
        FeatureUtils.sortFeatureList(summaryScores);
        return summaryScores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SummaryTile> getSummaryTilesForRange(String chr, int startLocation, int endLocation, int zoom) {
        assert (endLocation >= startLocation);
        if (zoom < this.getNumZoomLevels(chr)) {
            return this.getPrecomputedSummaryTiles(chr, startLocation, endLocation, zoom);
        }
        int chrLength = this.getChrLength(chr);
        if (chrLength == 0) {
            return Collections.emptyList();
        }
        endLocation = Math.min(endLocation, chrLength);
        int adjustedStart = Math.max(0, startLocation);
        int adjustedEnd = Math.min(chrLength, endLocation);
        int z = zoom;
        int nTiles = (int)Math.pow(2.0, z);
        double tileWidth = (double)chrLength / (double)nTiles;
        int startTile = (int)((double)adjustedStart / tileWidth);
        int endTile = (int)((double)Math.min(chrLength, adjustedEnd) / tileWidth) + 1;
        ArrayList<SummaryTile> tiles = new ArrayList<SummaryTile>(nTiles);
        for (int t = startTile; t <= endTile; ++t) {
            int tileStart = (int)((double)t * tileWidth);
            int tileEnd = Math.min(chrLength, (int)((double)(t + 1) * tileWidth));
            String key = chr + "_" + zoom + "_" + t + (Object)((Object)this.getWindowFunction());
            SummaryTile summaryTile = this.summaryTileCache.get(key);
            if (summaryTile == null) {
                summaryTile = this.computeSummaryTile(chr, t, tileStart, tileEnd);
                if (this.cacheSummaryTiles) {
                    LRUCache<String, SummaryTile> lRUCache = this.summaryTileCache;
                    synchronized (lRUCache) {
                        this.summaryTileCache.put(key, summaryTile);
                    }
                }
            }
            if (summaryTile == null) continue;
            tiles.add(summaryTile);
        }
        return tiles;
    }

    SummaryTile computeSummaryTile(String chr, int tileNumber, int startLocation, int endLocation) {
        int longestGene = this.getLongestFeature(chr);
        int adjustedStart = Math.max(startLocation - longestGene, 0);
        DataTile rawTile = this.getRawData(chr, adjustedStart, endLocation);
        SummaryTile tile = null;
        int nBins = Math.min(700, endLocation - startLocation);
        if (rawTile != null && !rawTile.isEmpty() && nBins > 0) {
            tile = new SummaryTile(tileNumber, startLocation);
            double binSize = (double)(endLocation - startLocation) / (double)nBins;
            Bin[] bins = new Bin[nBins];
            int[] starts = rawTile.getStartLocations();
            int[] ends = rawTile.getEndLocations();
            float[] values = rawTile.getValues();
            String[] features = rawTile.getFeatureNames();
            ArrayList<LocusScore> scores = new ArrayList<LocusScore>(700);
            for (int i2 = 0; i2 < starts.length; ++i2) {
                int endBin;
                int e2;
                int s = starts[i2];
                int n2 = e2 = ends == null ? s + 1 : Math.max(s + 1, ends[i2]);
                if (e2 < startLocation) continue;
                if (s > endLocation) break;
                String probeName = features == null ? null : features[i2];
                float v = values[i2];
                int startBin = (int)Math.max(0.0, (double)(s - startLocation) / binSize);
                if (startBin == (endBin = (int)Math.min((double)bins.length, (double)(e2 - startLocation) / binSize)) && endBin < bins.length) {
                    ++endBin;
                }
                for (int b2 = startBin; b2 < endBin; ++b2) {
                    Bin bin = bins[b2];
                    if (bin == null) {
                        int start = (int)((double)startLocation + (double)b2 * binSize);
                        int end = (int)((double)startLocation + (double)(b2 + 1) * binSize);
                        bins[b2] = new Bin(start, end, probeName, v, this.windowFunction);
                        continue;
                    }
                    bin.addValue(probeName, v);
                }
            }
            Bin currentBin = null;
            for (int b3 = 0; b3 < bins.length; ++b3) {
                if (bins[b3] == null) continue;
                if (currentBin == null) {
                    currentBin = bins[b3];
                    continue;
                }
                if (currentBin.isExtension(bins[b3])) {
                    currentBin.setEnd(bins[b3].getEnd());
                    continue;
                }
                scores.add(currentBin);
                currentBin = bins[b3];
            }
            if (currentBin != null) {
                scores.add(currentBin);
            }
            tile.addAllScores(scores);
        }
        return tile;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.windowFunction = statType;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return wfs;
    }

    static {
        wfs.add(WindowFunction.percentile10);
        wfs.add(WindowFunction.median);
        wfs.add(WindowFunction.mean);
        wfs.add(WindowFunction.percentile90);
        wfs.add(WindowFunction.max);
    }
}

