/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.data.Bin;
import org.broad.igv.feature.LocusScore;

public class FeatureBin
implements Bin {
    private int start;
    private List<LocusScore> features;

    public FeatureBin(int location) {
        this.start = location;
        this.features = new ArrayList<LocusScore>();
    }

    public void addFeature(LocusScore feature) {
        this.features.add(feature);
    }

    public List<LocusScore> getFeatures() {
        return this.features;
    }

    @Override
    public int getFeatureCount() {
        return this.getFeatures().size();
    }

    public float[] getFeatureScores() {
        int nScores = 0;
        for (LocusScore f2 : this.features) {
            if (Float.isNaN(f2.getScore())) continue;
            ++nScores;
        }
        if (nScores > 0) {
            float[] scores = new float[nScores];
            int scoreIndex = 0;
            for (LocusScore f3 : this.features) {
                float s = f3.getScore();
                if (Float.isNaN(s)) continue;
                scores[scoreIndex] = s;
                ++scoreIndex;
            }
            return scores;
        }
        return null;
    }

    @Override
    public int getStart() {
        return this.start;
    }
}

