/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Genome;
import org.broad.igv.tools.Accumulator;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class GenomeSummaryData {
    private static Logger log = Logger.getLogger(GenomeSummaryData.class);
    private static final double locationUnit = 1000.0;
    int nPixels = 1000;
    Genome genome;
    String[] samples;
    Map<String, Map<String, FloatArrayList>> dataMap = new HashMap<String, Map<String, FloatArrayList>>();
    Map<String, IntArrayList> locationMap;
    int[] locations;
    Map<String, float[]> data;
    int nDataPts = 0;
    double scale;

    public GenomeSummaryData(Genome genome, String[] samples) {
        this.genome = genome;
        this.samples = samples;
        this.scale = (double)genome.getLength() / 1000.0 / (double)this.nPixels;
        List<String> chrNames = genome.getChromosomeNames();
        this.locationMap = new HashMap<String, IntArrayList>();
        this.dataMap = new HashMap<String, Map<String, FloatArrayList>>();
        for (String chr : chrNames) {
            this.locationMap.put(chr, new IntArrayList(this.nPixels / 10));
            this.dataMap.put(chr, new HashMap());
            for (String s : samples) {
                this.dataMap.get(chr).put(s, new FloatArrayList(this.nPixels / 10));
            }
        }
    }

    public void addData(String chr, int[] locs, Map<String, float[]> sampleData) {
        IntArrayList locations = this.locationMap.get(chr);
        if (locations == null) {
            log.info("Skipping data for: " + chr);
        }
        int lastPixel = -1;
        HashMap<String, Accumulator> dataPoints = new HashMap<String, Accumulator>();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            int genomeLocation = this.genome.getGenomeCoordinate(chr, locs[i2]);
            int pixel = (int)((double)genomeLocation / this.scale);
            if (i2 > 0 && pixel != lastPixel) {
                ++this.nDataPts;
                locations.add(genomeLocation);
                for (String s : this.dataMap.get(chr).keySet()) {
                    Accumulator dp = (Accumulator)dataPoints.get(s);
                    dp.finish();
                    this.dataMap.get(chr).get(s).add(dp.getValue(WindowFunction.mean));
                }
                dataPoints.clear();
            }
            for (String s : this.samples) {
                float[] data = sampleData.get(s);
                Accumulator dp = (Accumulator)dataPoints.get(s);
                if (dp == null) {
                    dp = new Accumulator(Arrays.asList(WindowFunction.mean));
                    dataPoints.put(s, dp);
                }
                try {
                    dp.add(data[i2]);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            lastPixel = pixel;
        }
    }

    public int[] getLocations() {
        if (this.locations == null) {
            this.createDataArrays();
        }
        return this.locations;
    }

    public float[] getData(String sample) {
        if (!this.data.containsKey(sample)) {
            this.createDataArrays();
        }
        return this.data.get(sample);
    }

    private synchronized void createDataArrays() {
        this.locations = new int[this.nDataPts];
        int offset = 0;
        List<String> chrNames = this.genome.getChromosomeNames();
        for (String chr : chrNames) {
            int[] chrLocs = this.locationMap.get(chr).toArray();
            System.arraycopy(chrLocs, 0, this.locations, offset, chrLocs.length);
            offset += chrLocs.length;
        }
        this.data = new HashMap<String, float[]>();
        for (String s : this.samples) {
            float[] sampleData = new float[this.nDataPts];
            offset = 0;
            for (String chr : chrNames) {
                float[] chrData = this.dataMap.get(chr).get(s).toArray();
                System.arraycopy(chrData, 0, sampleData, offset, chrData.length);
                offset += chrData.length;
            }
            this.data.put(s, sampleData);
        }
        this.locationMap.clear();
        this.dataMap.clear();
    }
}

