/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.data.CompositeScore;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.IntArrayList;

public class ProcessingUtils {
    protected static int[] findBoundaries(List<LocusScore> scores) {
        int[] boundaries = new int[2 * scores.size() + 1];
        for (int i2 = 0; i2 < scores.size(); ++i2) {
            LocusScore score = scores.get(i2);
            boundaries[2 * i2] = score.getStart();
            boundaries[2 * i2 + 1] = score.getEnd();
        }
        Arrays.sort(boundaries);
        IntArrayList boundaryList = new IntArrayList(boundaries.length);
        int lastPos = -1;
        for (int i3 = 0; i3 < boundaries.length; ++i3) {
            if (boundaries[i3] == lastPos) continue;
            lastPos = boundaries[i3];
            boundaryList.add(lastPos);
        }
        boundaries = boundaryList.toArray();
        return boundaries;
    }

    private static boolean nullDataCheck(float[] data) {
        boolean noData = true;
        if (data != null && data.length > 0) {
            for (int i2 = 0; i2 < data.length; ++i2) {
                if (Float.isNaN(data[i2])) continue;
                noData = false;
                break;
            }
        }
        return noData;
    }

    private static float computeQuantile(float[] data, double quantile) {
        double[] dData = new double[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            dData[i2] = data[i2];
        }
        return (float)StatUtils.percentile(dData, quantile);
    }

    private static float computeMin(float[] data) {
        float min = Float.MAX_VALUE;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Float.isNaN(data[i2])) continue;
            min = Math.min(data[i2], min);
        }
        return min;
    }

    private static float computeMax(float[] data) {
        float max = -3.4028235E38f;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Float.isNaN(data[i2])) continue;
            max = Math.max(data[i2], max);
        }
        return max;
    }

    private static float computeMean(float[] data) {
        float sum = 0.0f;
        int nPts = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Float.isNaN(data[i2])) continue;
            sum += data[i2];
            ++nPts;
        }
        return nPts == 0 ? Float.NaN : sum / (float)nPts;
    }

    public static float computeStat(float[] data, WindowFunction function) {
        if (ProcessingUtils.nullDataCheck(data)) {
            return Float.NaN;
        }
        switch (function) {
            case mean: {
                return ProcessingUtils.computeMean(data);
            }
            case median: {
                return ProcessingUtils.computeQuantile(data, 50.0);
            }
            case min: {
                return ProcessingUtils.computeMin(data);
            }
            case max: {
                return ProcessingUtils.computeMax(data);
            }
            case percentile2: {
                return ProcessingUtils.computeQuantile(data, 2.0);
            }
            case percentile10: {
                return ProcessingUtils.computeQuantile(data, 10.0);
            }
            case percentile90: {
                return ProcessingUtils.computeQuantile(data, 90.0);
            }
            case percentile98: {
                return ProcessingUtils.computeQuantile(data, 98.0);
            }
            case count: {
                return data.length;
            }
        }
        return Float.NaN;
    }

    public static List<LocusScore> segregateScores(List<LocusScore> scores, WindowFunction wf) {
        int[] boundaries = ProcessingUtils.findBoundaries(scores);
        LinkedHashMap<Integer, Interval> intervals = new LinkedHashMap<Integer, Interval>(2 * scores.size());
        for (int i2 = 1; i2 < boundaries.length; ++i2) {
            int end = boundaries[i2];
            int start = boundaries[i2 - 1];
            if (end <= start) continue;
            intervals.put(start, new Interval(start, end));
        }
        HashMap<Integer, Integer> reverseMap = new HashMap<Integer, Integer>();
        for (int i3 = 0; i3 < boundaries.length; ++i3) {
            reverseMap.put(boundaries[i3], i3);
        }
        for (LocusScore score : scores) {
            int start = score.getStart();
            int end = score.getEnd();
            int idxStart = (Integer)reverseMap.get(start);
            int idxEnd = reverseMap.containsKey(end) ? (Integer)reverseMap.get(end) : boundaries.length - 1;
            int pos = -1;
            for (int i4 = idxStart; i4 < idxEnd; ++i4) {
                if (boundaries[i4] == pos) continue;
                pos = boundaries[i4];
                Interval interval = (Interval)intervals.get(pos);
                if (interval.end > score.getEnd()) continue;
                LocusScore tmp = score.copy();
                tmp.setStart(interval.start);
                tmp.setEnd(interval.end);
                interval.scores.add(tmp);
            }
        }
        ArrayList<LocusScore> segScores = new ArrayList<LocusScore>(scores.size());
        for (Interval interval : intervals.values()) {
            if (interval.scores.size() <= 0) continue;
            if (interval.scores.size() == 1) {
                segScores.add(interval.scores.get(0));
                continue;
            }
            segScores.add(new CompositeScore(interval.scores, wf));
        }
        return segScores;
    }

    static class Interval {
        int start;
        int end;
        List<LocusScore> scores = new ArrayList<LocusScore>(3);

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

