/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.Dataset;
import org.broad.igv.feature.Genome;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ArrayHeapIntSorter;
import org.broad.igv.util.IntComparator;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class WiggleDataset
implements Dataset {
    String genome;
    private String name;
    private TrackProperties trackProperties;
    Map<String, IntArrayList> startLocationsMap = new HashMap<String, IntArrayList>();
    Map<String, IntArrayList> endLocationsMap = new HashMap<String, IntArrayList>();
    Map<String, FloatArrayList> dataMap = new HashMap<String, FloatArrayList>();
    float dataMin = 0.0f;
    float dataMax = 0.0f;
    private Map<String, Integer> longestFeatureMap;

    public WiggleDataset(String genomeId, String name) {
        this.genome = genomeId;
        this.name = name;
        this.trackProperties = new TrackProperties();
    }

    public void sort(Set<String> unsortedChromosomes) {
        Genome genome = ViewContext.getInstance().getGenome();
        for (String c2 : unsortedChromosomes) {
            String chr = genome.getChromosomeAlias(c2);
            final IntArrayList starts = this.startLocationsMap.get(chr);
            int sz = starts.size();
            int[] indeces = new int[sz];
            for (int i2 = 0; i2 < indeces.length; ++i2) {
                indeces[i2] = i2;
            }
            new ArrayHeapIntSorter().sort(indeces, new IntComparator(){

                @Override
                public int compare(int arg0, int arg1) {
                    return starts.get(arg0) - starts.get(arg1);
                }
            });
            int[] sortedStarts = this.reorder(indeces, this.startLocationsMap.get(chr));
            int[] sortedEnds = this.reorder(indeces, this.endLocationsMap.get(chr));
            float[] sortedData = this.reorder(indeces, this.dataMap.get(chr));
            this.startLocationsMap.put(chr, new IntArrayList(sortedStarts));
            this.endLocationsMap.put(chr, new IntArrayList(sortedEnds));
            this.dataMap.put(chr, new FloatArrayList(sortedData));
        }
    }

    private float[] reorder(int[] indeces, FloatArrayList values) {
        int size = values.size();
        if (indeces.length != size) {
            throw new IllegalArgumentException("Index array length not equal to size");
        }
        float[] reorderedValues = new float[size];
        for (int i2 = 0; i2 < size; ++i2) {
            reorderedValues[i2] = values.get(indeces[i2]);
        }
        return reorderedValues;
    }

    private int[] reorder(int[] indeces, IntArrayList values) {
        int size = values.size();
        if (indeces.length != size) {
            throw new IllegalArgumentException("Index array length not equal to size");
        }
        int[] reorderedValues = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            reorderedValues[i2] = values.get(indeces[i2]);
        }
        return reorderedValues;
    }

    public void addDataChunk(String chr, IntArrayList starts, IntArrayList ends, FloatArrayList data) {
        FloatArrayList dataArray;
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        if (startLocations == null) {
            this.startLocationsMap.put(chr, starts);
        } else {
            startLocations.addAll(starts);
        }
        if (ends != null) {
            IntArrayList endLocations = this.endLocationsMap.get(chr);
            if (endLocations == null) {
                this.endLocationsMap.put(chr, ends);
            } else {
                endLocations.addAll(ends);
            }
        }
        if ((dataArray = this.dataMap.get(chr)) == null) {
            this.dataMap.put(chr, data);
        } else {
            dataArray.addAll(data);
        }
        float[] d2 = data.toArray();
        for (int i2 = 0; i2 < d2.length; ++i2) {
            this.dataMax = Math.max(this.dataMax, d2[i2]);
            this.dataMin = Math.min(this.dataMin, d2[i2]);
        }
    }

    @Override
    public float getDataMin() {
        return this.dataMin;
    }

    @Override
    public float getDataMax() {
        return this.dataMax;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TrackType getType() {
        return TrackType.OTHER;
    }

    @Override
    public String getGenome() {
        return this.genome;
    }

    @Override
    public String[] getChromosomes() {
        return this.startLocationsMap.keySet().toArray(new String[0]);
    }

    @Override
    public String[] getDataHeadings() {
        return new String[]{this.getName()};
    }

    @Override
    public int[] getStartLocations(String chr) {
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        if (startLocations == null) {
            return null;
        }
        return startLocations.toArray();
    }

    @Override
    public int[] getEndLocations(String chr) {
        IntArrayList endLocations = this.endLocationsMap.get(chr);
        if (endLocations == null) {
            return null;
        }
        return endLocations.toArray();
    }

    @Override
    public float[] getData(String heading, String chr) {
        FloatArrayList data = this.dataMap.get(chr);
        if (data == null) {
            return null;
        }
        return data.toArray();
    }

    @Override
    public String[] getFeatureNames(String chr) {
        return null;
    }

    @Override
    public int getWindowSpan() {
        return 1;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    @Override
    public Integer getLongestFeature(String chr) {
        return this.longestFeatureMap == null ? 1000 : (this.longestFeatureMap.containsKey(chr) ? this.longestFeatureMap.get(chr) : 1);
    }

    public void setLongestFeatureMap(Map<String, Integer> longestFeatureMap) {
        this.longestFeatureMap = longestFeatureMap;
    }
}

