/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.data.rnai.RNAIDataSource;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.data.rnai.RNAIHairpinCache;
import org.broad.igv.data.rnai.RNAIHairpinValue;
import org.broad.igv.exceptions.LoadResourceFromServerException;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.ProbeToGeneMap;
import org.broad.igv.session.ViewContext;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class RNAIGCTDatasetParser {
    private static Logger log = Logger.getLogger(RNAIGCTDatasetParser.class);
    private ResourceLocator dataFileLocator;
    private int dataStartColumn = 2;
    private int descriptionColumn = 1;
    private final String RNAI_MAPPING_FILE = "http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz";
    GeneManager geneManager = null;

    public RNAIGCTDatasetParser(ResourceLocator gctFile) {
        this.dataFileLocator = gctFile;
        this.dataStartColumn = 2;
        String genome = ViewContext.getInstance().getGenomeId();
        this.geneManager = GeneManager.getGeneManager(genome);
    }

    public Collection<RNAIDataSource> parse() {
        AsciiLineReader reader = null;
        List dataSources = null;
        String nextLine = null;
        InputStream probeMappingStream = null;
        try {
            String[] tokens = new String[1000];
            reader = ParsingUtils.openAsciiReader(this.dataFileLocator);
            String headerLine = null;
            nextLine = reader.readLine();
            nextLine = reader.readLine();
            headerLine = reader.readLine();
            int skip = 1;
            int nTokens = ParsingUtils.split(headerLine, tokens, '\t');
            String description = nTokens > this.descriptionColumn ? new String(tokens[this.descriptionColumn]) : null;
            int nColumns = (nTokens - this.dataStartColumn) / skip;
            String[] columnHeadings = new String[nColumns];
            for (int i2 = 0; i2 < nColumns; ++i2) {
                String heading;
                columnHeadings[i2] = heading = tokens[this.dataStartColumn + i2 * skip].replace('\"', ' ').trim();
            }
            Map<String, String[]> rnaiProbeMap = ProbeToGeneMap.getInstance().getRNAiProbeMap();
            URL url = new URL("http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz");
            probeMappingStream = new GZIPInputStream(IGVHttpUtils.openConnectionStream(url));
            if (probeMappingStream == null) {
                log.error("Could not retrieve probe mapping file: http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz");
                Collection<RNAIDataSource> collection = null;
                return collection;
            }
            if (rnaiProbeMap == null || rnaiProbeMap.isEmpty()) {
                AsciiLineReader br = null;
                try {
                    br = new AsciiLineReader(probeMappingStream);
                    rnaiProbeMap = new HashMap<String, String[]>();
                    ProbeToGeneMap.getInstance().loadMapping(br, rnaiProbeMap);
                }
                catch (Exception e2) {
                    throw new LoadResourceFromServerException(e2.getMessage(), "http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz", e2.getClass().getSimpleName());
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            HashMap<String, HashMap<String, Float>> sampleGeneScoreMap = new HashMap<String, HashMap<String, Float>>();
            while ((nextLine = reader.readLine()) != null) {
                nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                String probeId = new String(tokens[0]);
                float[] values = new float[nColumns];
                String[] identifiers = rnaiProbeMap.get(probeId);
                String identifier = null;
                if (identifiers == null || identifiers.length == 0) {
                    log.info("Could not find mapping for: " + probeId);
                    continue;
                }
                identifier = identifiers[0];
                Feature gene = FeatureDB.getFeature(identifier.toUpperCase());
                if (gene == null) {
                    log.debug("Unknown identifier: " + identifier);
                    continue;
                }
                for (int i3 = 0; i3 < nColumns; ++i3) {
                    try {
                        Float geneScore;
                        int dataIndex = this.dataStartColumn + i3 * skip;
                        values[i3] = dataIndex >= nTokens || tokens[dataIndex].length() == 0 ? Float.NaN : Float.parseFloat(tokens[dataIndex]);
                        String sample = columnHeadings[i3];
                        RNAIHairpinValue hairpin = new RNAIHairpinValue(probeId, values[i3]);
                        RNAIHairpinCache.getInstance().addHairpinScore(sample, gene.getName(), hairpin);
                        HashMap<String, Float> geneScoreMap = sampleGeneScoreMap.get(sample);
                        if (geneScoreMap == null) {
                            geneScoreMap = new HashMap();
                            sampleGeneScoreMap.put(sample, geneScoreMap);
                        }
                        if ((geneScore = geneScoreMap.get(gene.getName())) == null) {
                            geneScore = Float.valueOf(values[i3]);
                            geneScoreMap.put(gene.getName(), geneScore);
                            continue;
                        }
                        geneScore = new Float(Math.min(values[i3], geneScore.floatValue()));
                        geneScoreMap.put(gene.getName(), geneScore);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        values[i3] = Float.NaN;
                    }
                }
            }
            dataSources = this.computeGeneScores(sampleGeneScoreMap);
        }
        catch (IOException ex) {
            log.error("Error parsing RNAi file", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (probeMappingStream != null) {
                try {
                    probeMappingStream.close();
                }
                catch (IOException e3) {
                    log.error("Error closing probe mapping stream", e3);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
        return dataSources;
    }

    private List computeGeneScores(HashMap<String, HashMap<String, Float>> sampleGeneScoreMap) {
        int confidence = 3;
        ArrayList<RNAIDataSource> dataSources = new ArrayList<RNAIDataSource>();
        for (String sample : sampleGeneScoreMap.keySet()) {
            HashMap<String, Float> geneMap = sampleGeneScoreMap.get(sample);
            RNAIDataSource ds = new RNAIDataSource(sample, "");
            for (String gene : geneMap.keySet()) {
                Float score = geneMap.get(gene);
                Collection<RNAIHairpinValue> hairpins = RNAIHairpinCache.getInstance().getHairpinScores(sample, gene);
                int numHairpins = hairpins == null ? 0 : hairpins.size();
                ds.addGeneScore(new RNAIGeneScore(sample, FeatureDB.getFeature(gene), score.floatValue(), numHairpins));
            }
            dataSources.add(ds);
        }
        return dataSources;
    }
}

