/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.apache.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.UCSCParser;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class BEDFileParser
extends UCSCParser {
    private static Logger log = Logger.getLogger(BEDFileParser.class);

    @Override
    public boolean isFeatureFile(ResourceLocator locator) {
        String ext = BEDFileParser.getStrippedFilename(locator.getPath());
        return ext.endsWith("bed");
    }

    @Override
    public BasicFeature parseLine(String[] tokens, int tokenCount) {
        if (tokenCount < 2) {
            return null;
        }
        String chr = this.genome == null ? tokens[0] : this.genome.getChromosomeAlias(tokens[0]);
        int start = Integer.parseInt(tokens[1]) - this.startBase;
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = tokens[3].replaceAll("\"", "");
            feature.setName(name);
            feature.setIdentifier(name);
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(tokens[4]);
                feature.setScore(score);
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n2 = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 7) {
            feature.setThickStart(Integer.parseInt(tokens[6]));
            feature.setThickEnd(Integer.parseInt(tokens[7]));
        }
        if (tokenCount > 8) {
            String[] rgb = new String[3];
            int nTokens = ParsingUtils.split(tokens[8].replaceAll("\"", ""), rgb, ',');
            feature.setColor(rgb, nTokens);
        }
        if (tokenCount > 11) {
            this.createExons(start, tokens, feature, chr, feature.getStrand());
        }
        return feature;
    }

    private void createExons(int start, String[] tokens, BasicFeature gene, String chr, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]) - this.startBase;
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = new String[exonCount];
        String[] startsBuffer = new String[exonCount];
        ParsingUtils.split(tokens[10], exonSizes, ',');
        ParsingUtils.split(tokens[11], startsBuffer, ',');
        int n2 = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i2 = 0; i2 < startsBuffer.length; ++i2) {
                int exonStart = start + Integer.parseInt(startsBuffer[i2]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i2]);
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                exon.setCodingStart(cdStart);
                exon.setCodingEnd(cdEnd);
                exon.setNumber(exonNumber);
                gene.addExon(exon);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }
}

