/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.BasicFeatureRenderer;
import org.broad.igv.renderer.GeneTrackRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;

public class GFFParser
implements FeatureParser {
    static Logger log = Logger.getLogger(GFFParser.class);
    static HashSet exonTerms = new HashSet();
    static HashSet utrTerms = new HashSet();
    static HashSet<String> geneParts = new HashSet();
    static HashSet<String> ignoredTypes = new HashSet();
    static String[] nameFields = new String[]{"gene", "Name", "name", "primary_name", "Locus", "locus", "alias", "systematic_id", "ID"};
    static String[] tokens = new String[200];
    Helper helper;
    Map<String, GFF3Transcript> transcriptCache = new HashMap<String, GFF3Transcript>(50000);
    Map<String, BasicFeature> geneCache = new HashMap<String, BasicFeature>(50000);
    private TrackProperties trackProperties = null;
    static StringBuffer buf;

    public GFFParser(String path) {
        this.helper = path.toLowerCase().endsWith("gff3") || path.toLowerCase().endsWith("gff3.gz") ? new GFF3Helper() : new GFF2Helper();
    }

    @Override
    public boolean isFeatureFile(ResourceLocator locator) {
        return true;
    }

    @Override
    public List<FeatureTrack> loadTracks(ResourceLocator locator) {
        if (locator.getPath().toLowerCase().endsWith("gff3") || locator.getPath().toLowerCase().endsWith("gff3.gz")) {
            this.helper = new GFF3Helper();
        }
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            List<Feature> features = this.loadFeatures(reader);
            if (features.size() == 0) {
                throw new DataLoadException("No features were found in this file with chromosomes mapped to the current genome", locator.getPath());
            }
            FeatureTrack track = new FeatureTrack(locator, (FeatureSource)new FeatureCollectionSource(features));
            track.setName(locator.getTrackName());
            track.setRendererClass(BasicFeatureRenderer.class);
            track.setMinimumHeight(35);
            track.setHeight(45);
            track.setRendererClass(GeneTrackRenderer.class);
            if (this.trackProperties != null) {
                track.setTrackProperties(this.trackProperties);
            }
            ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
            tracks.add(track);
            ArrayList<FeatureTrack> arrayList = tracks;
            return arrayList;
        }
        catch (Exception ex) {
            log.error(ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public List<Feature> loadFeatures(AsciiLineReader reader) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        URLDecoder d2 = new URLDecoder();
        String line = null;
        try {
            Genome genome = ViewContext.getInstance().getGenome();
            HashSet<String> featuresToHide = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                int end;
                int start;
                if (line.startsWith("##gff-version") && line.endsWith("3")) {
                    this.helper = new GFF3Helper();
                }
                if (line.startsWith("#")) {
                    String[] kv;
                    if (line.startsWith("#track") || line.startsWith("##track")) {
                        this.trackProperties = new TrackProperties();
                        ParsingUtils.parseTrackLine(line, this.trackProperties);
                        continue;
                    }
                    if (line.startsWith("#nodecode")) {
                        this.helper.setUrlDecoding(false);
                        continue;
                    }
                    if (!line.startsWith("#hide") || (kv = line.split("=")).length <= 1) continue;
                    featuresToHide.addAll(Arrays.asList(kv[1].split(",")));
                    continue;
                }
                int nTokens = ParsingUtils.split(line, tokens, '\t');
                if (nTokens < 9) {
                    if (!line.startsWith("track")) continue;
                    this.trackProperties = new TrackProperties();
                    ParsingUtils.parseTrackLine(line, this.trackProperties);
                    continue;
                }
                String featureType = new String(tokens[2].trim());
                if (ignoredTypes.contains(featureType)) continue;
                String chromosome = genome.getChromosomeAlias(tokens[0]);
                try {
                    start = Integer.parseInt(tokens[3]) - 1;
                }
                catch (NumberFormatException ne) {
                    throw new ParserException("Column 4 must contain a numeric value", reader.getCurrentLineNumber(), line);
                }
                try {
                    end = Integer.parseInt(tokens[4]);
                }
                catch (NumberFormatException ne) {
                    throw new ParserException("Column 5 must contain a numeric value", reader.getCurrentLineNumber(), line);
                }
                Strand strand = this.convertStrand(tokens[6]);
                String attributeString = tokens[8];
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                this.helper.parseAttributes(attributeString, attributes);
                String description = GFFParser.getDescription(attributes, featureType);
                String id = this.helper.getID(attributes);
                String[] parentIds = this.helper.getParentIds(attributes, attributeString);
                if (featureType.equals("CDS_parts")) {
                    for (String pid : parentIds) {
                        this.getGFF3Transcript(pid).addCDSParts(chromosome, start, end, description);
                    }
                    continue;
                }
                if (featureType.equals("intron")) {
                    for (String pid : parentIds) {
                        this.getGFF3Transcript(pid).addCDSParts(chromosome, start, end, description);
                    }
                    continue;
                }
                if (exonTerms.contains(featureType) && parentIds != null && parentIds.length > 0 && parentIds[0] != null && parentIds[0].length() > 0 && !parentIds[0].equals(".")) {
                    String name = this.getName(attributes);
                    int phase = -1;
                    String phaseString = tokens[7].trim();
                    if (!phaseString.equals(".")) {
                        try {
                            phase = Integer.parseInt(phaseString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("GFF3 error: non numeric phase: " + phaseString);
                        }
                    }
                    for (String pid : parentIds) {
                        Exon exon = new Exon(chromosome, start, end, strand);
                        exon.setDescription(description);
                        exon.setUTR(utrTerms.contains(featureType));
                        if (phase >= 0) {
                            exon.setPhase(phase);
                        }
                        exon.setName(name);
                        if (featureType.equals("exon")) {
                            this.getGFF3Transcript(pid).addExon(exon);
                            continue;
                        }
                        if (featureType.equals("CDS")) {
                            this.getGFF3Transcript(pid).addCDS(exon);
                            continue;
                        }
                        if (featureType.equals("five_prime_UTR") || featureType.equals("5'-UTR")) {
                            this.getGFF3Transcript(pid).setFivePrimeUTR(exon);
                            continue;
                        }
                        if (!featureType.equals("three_prime_UTR") && !featureType.equals("3'-UTR")) continue;
                        this.getGFF3Transcript(pid).setThreePrimeUTR(exon);
                    }
                    continue;
                }
                BasicFeature f2 = new BasicFeature(chromosome, start, end, strand);
                f2.setName(this.getName(attributes));
                f2.setDescription(description);
                if (attributes.containsKey("color")) {
                    f2.setColor(ColorUtilities.getColorFromString(attributes.get("color")));
                }
                if (attributes.containsKey("Color")) {
                    f2.setColor(ColorUtilities.getColorFromString(attributes.get("Color")));
                }
                if (id == null) {
                    features.add(f2);
                    continue;
                }
                f2.setIdentifier(id);
                if (featureType.equals("gene")) {
                    this.geneCache.put(id, f2);
                    if (featuresToHide.contains(featureType)) {
                        FeatureDB.addFeature(f2);
                        continue;
                    }
                    features.add(f2);
                    continue;
                }
                if (featureType.equals("mRNA") || featureType.equals("transcript")) {
                    String pid = null;
                    if (parentIds != null && parentIds.length > 0) {
                        pid = parentIds[0];
                    }
                    this.getGFF3Transcript(id).transcript(f2, pid);
                    continue;
                }
                if (featuresToHide.contains(featureType)) {
                    FeatureDB.addFeature(f2);
                    continue;
                }
                features.add(f2);
            }
            for (GFF3Transcript transcript : this.transcriptCache.values()) {
                BasicFeature igvGene = transcript.createIGVGene();
                if (igvGene == null) continue;
                features.add(igvGene);
            }
            FeatureDB.addFeatures(features);
        }
        catch (ParserException e2) {
            throw e2;
        }
        catch (Exception ex) {
            log.error("Error parsing GFF file", ex);
            if (line != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(ex.getMessage(), (Throwable)ex, reader.getCurrentLineNumber(), line);
            }
            throw new RuntimeException(ex);
        }
        return features;
    }

    static String getDescription(Map<String, String> attributes, String type) {
        buf.setLength(0);
        buf.append(type);
        buf.append("<br>");
        for (Map.Entry<String, String> att : attributes.entrySet()) {
            String attValue = att.getValue().replaceAll(";", "<br>");
            buf.append(att.getKey());
            buf.append(" = ");
            buf.append(attValue);
            buf.append("<br>");
        }
        String description = buf.toString();
        return description;
    }

    private Strand convertStrand(String strandString) {
        Strand strand = Strand.NONE;
        if (strandString.equals("-")) {
            strand = Strand.NEGATIVE;
        } else if (strandString.equals("+")) {
            strand = Strand.POSITIVE;
        }
        return strand;
    }

    private GFF3Transcript getGFF3Transcript(String id) {
        GFF3Transcript transcript = this.transcriptCache.get(id);
        if (transcript == null) {
            transcript = new GFF3Transcript(id);
            this.transcriptCache.put(id, transcript);
        }
        return transcript;
    }

    String getName(Map<String, String> attributes) {
        if (attributes.size() == 0) {
            return null;
        }
        for (String nf : nameFields) {
            if (!attributes.containsKey(nf)) continue;
            return attributes.get(nf);
        }
        return attributes.values().iterator().next();
    }

    public static void splitFileByType(String gffFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(gffFile));
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#")) continue;
            int nTokens = ParsingUtils.split(nextLine.trim().replaceAll("\"", ""), tokens, '\t');
            String type = tokens[2];
            if (geneParts.contains(type)) {
                type = "gene";
            }
            if (writers.containsKey(type)) continue;
            writers.put(type, new PrintWriter(new FileWriter(new File(outputDirectory, type + ".gff"))));
        }
        br.close();
        br = new BufferedReader(new FileReader(gffFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#")) {
                ParsingUtils.split(nextLine.trim().replaceAll("\"", ""), tokens, '\t');
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            int nTokens = ParsingUtils.split(nextLine.trim().replaceAll("\"", ""), tokens, '\t');
            String type = tokens[2];
            if (geneParts.contains(type)) {
                type = "gene";
            }
            if ((currentWriter = (PrintWriter)writers.get(type)) != null) {
                currentWriter.println(nextLine);
                continue;
            }
            System.out.println("No writer for: " + type);
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("SpitFilesByType <gffFile> <outputDirectory>");
            return;
        }
        GFFParser.splitFileByType(args[0], args[1]);
    }

    static {
        utrTerms.add("five_prime_UTR");
        utrTerms.add("three_prime_UTR");
        utrTerms.add("5'-utr");
        utrTerms.add("3'-utr");
        utrTerms.add("3'-UTR");
        utrTerms.add("5'-UTR");
        utrTerms.add("5utr");
        utrTerms.add("3utr");
        exonTerms.addAll(utrTerms);
        exonTerms.add("exon");
        exonTerms.add("coding_exon");
        exonTerms.add("CDS");
        exonTerms.add("cds");
        geneParts.addAll(exonTerms);
        geneParts.add("transcript");
        geneParts.add("processed_transcript");
        geneParts.add("mrna");
        geneParts.add("mRNA");
        geneParts.add("promoter");
        geneParts.add("intron");
        geneParts.add("CDS_parts");
        ignoredTypes.add("start_codon");
        ignoredTypes.add("stop_codon");
        ignoredTypes.add("Contig");
        ignoredTypes.add("RealContig");
        ignoredTypes.add("intron");
        buf = new StringBuffer(1000);
    }

    class GFF3Helper
    implements Helper {
        private boolean useUrlDecoding = true;

        GFF3Helper() {
        }

        @Override
        public String[] getParentIds(Map<String, String> attributes, String ignored) {
            String parentIdString = attributes.get("Parent");
            if (parentIdString != null) {
                return attributes.get("Parent").split(",");
            }
            return null;
        }

        @Override
        public void parseAttributes(String description, Map<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                List<String> tmp = StringUtils.breakQuotedString(kv, '=');
                int nValues = tmp.size();
                if (nValues > 0) {
                    String value;
                    String key = tmp.get(0).trim();
                    String string = value = nValues == 1 ? "" : tmp.get(1).trim();
                    if (this.useUrlDecoding) {
                        key = URLDecoder.decode(key);
                        value = URLDecoder.decode(value);
                    }
                    kvalues.put(key, value);
                    continue;
                }
                log.info("No attributes: " + description);
            }
        }

        @Override
        public void setUrlDecoding(boolean useUrlDecoding) {
            this.useUrlDecoding = useUrlDecoding;
        }

        @Override
        public String getID(Map<String, String> attributes) {
            String id = attributes.get("ID");
            return id;
        }
    }

    class GFF2Helper
    implements Helper {
        String[] idFields = new String[]{"systematic_id", "ID", "transcript_id", "Name", "name", "primary_name", "gene", "Locus", "locus", "alias"};

        GFF2Helper() {
        }

        @Override
        public void setUrlDecoding(boolean b2) {
        }

        @Override
        public void parseAttributes(String description, Map<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                List<String> tokens = StringUtils.breakQuotedString(kv, ' ');
                if (tokens.size() < 2) continue;
                String key = tokens.get(0).trim().replaceAll("\"", "");
                String value = tokens.get(1).trim().replaceAll("\"", "");
                kvalues.put(key, value);
            }
        }

        @Override
        public String[] getParentIds(Map<String, String> attributes, String attributeString) {
            String[] parentIds = new String[1];
            if (attributes.isEmpty()) {
                parentIds[0] = attributeString;
            } else {
                parentIds[0] = attributes.get("id");
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("mRNA");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("systematic_id");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("transcript_id");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("gene");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("transcriptId");
                }
                if (parentIds[0] == null) {
                    parentIds[0] = attributes.get("proteinId");
                }
            }
            return parentIds;
        }

        @Override
        public String getID(Map<String, String> attributes) {
            for (String nf : this.idFields) {
                if (!attributes.containsKey(nf)) continue;
                return attributes.get(nf);
            }
            return GFFParser.this.getName(attributes);
        }
    }

    protected static interface Helper {
        public String[] getParentIds(Map<String, String> var1, String var2);

        public void parseAttributes(String var1, Map<String, String> var2);

        public String getID(Map<String, String> var1);

        public void setUrlDecoding(boolean var1);
    }

    class GFF3Transcript {
        private String id;
        private Set<Exon> exons = new HashSet<Exon>();
        private List<Exon> cdss = new ArrayList<Exon>();
        private Exon fivePrimeUTR;
        private Exon threePrimeUTR;
        private BasicFeature transcript;
        private String parentId;
        String chr = null;
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        String description;

        GFF3Transcript(String id) {
            this.id = id;
        }

        void transcript(BasicFeature mRNA, String parent) {
            int prefixIndex;
            this.transcript = mRNA;
            this.parentId = parent;
            if (mRNA.getName() == null) {
                mRNA.setName(mRNA.getIdentifier());
            }
            if ((prefixIndex = mRNA.getName().indexOf(":")) > 0) {
                mRNA.setName(mRNA.getName().substring(prefixIndex + 1));
            }
        }

        void setFivePrimeUTR(Exon exon) {
            this.fivePrimeUTR = exon;
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void setThreePrimeUTR(Exon exon) {
            this.threePrimeUTR = exon;
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void addExon(Exon exon) {
            this.exons.add(exon);
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void addCDS(Exon cds) {
            this.cdss.add(cds);
        }

        void addCDSParts(String chr, int start, int end, String desc) {
            this.chr = chr;
            this.start = Math.min(this.start, start);
            this.end = Math.max(this.end, end);
            this.appendDescription(desc);
        }

        void appendDescription(String desc) {
            this.description = this.description == null ? "<html>" : this.description + "<br>---------<br>";
            this.description = this.description + desc;
        }

        BasicFeature createIGVGene() {
            Exon exon;
            Strand strand = Strand.NONE;
            String name = null;
            while (!this.cdss.isEmpty()) {
                Exon cds = this.cdss.get(0);
                Exon exon2 = this.findMatchingExon(cds);
                if (exon2 == null) {
                    cds.setCodingStart(cds.getStart());
                    cds.setCodingEnd(cds.getEnd());
                    this.exons.add(cds);
                } else {
                    exon2.setCodingStart(cds.getStart());
                    exon2.setCodingEnd(cds.getEnd());
                    exon2.setReadingFrame(cds.getReadingShift());
                }
                this.cdss.remove(0);
            }
            for (Exon exon2 : this.exons) {
                this.chr = exon2.getChr();
                strand = exon2.getStrand();
                this.start = Math.min(exon2.getStart(), this.start);
                this.end = Math.max(exon2.getEnd(), this.end);
                name = exon2.getName();
            }
            if (this.transcript == null) {
                this.transcript = new BasicFeature(this.chr, this.start, this.end, strand);
                this.transcript.setIdentifier(this.id);
                this.transcript.setName(name == null ? this.id : name);
                this.transcript.setDescription(this.description);
            }
            if (this.parentId != null && GFFParser.this.geneCache.containsKey(this.parentId)) {
                BasicFeature gene = GFFParser.this.geneCache.get(this.parentId);
                if (this.transcript.getName() == null && gene.getName() != null) {
                    this.transcript.setName(gene.getName());
                }
                this.transcript.setDescription("Transcript<br>" + this.transcript.getDescription() + "<br>--------<br>Gene<br>" + gene.getDescription());
            }
            for (Exon exon2 : this.exons) {
                this.transcript.addExon(exon2);
            }
            this.transcript.sortExons();
            if (this.fivePrimeUTR != null) {
                this.fivePrimeUTR.setUTR(true);
                this.transcript.addExon(this.fivePrimeUTR);
                exon = this.findMatchingExon(this.fivePrimeUTR);
                if (exon != null) {
                    if (exon.getStrand() == Strand.POSITIVE) {
                        exon.setStart(this.fivePrimeUTR.getEnd());
                    } else {
                        exon.setEnd(this.fivePrimeUTR.getStart());
                    }
                }
            }
            if (this.threePrimeUTR != null) {
                this.threePrimeUTR.setUTR(true);
                this.transcript.addExon(this.threePrimeUTR);
                exon = this.findMatchingExon(this.threePrimeUTR);
                if (exon != null) {
                    if (exon.getStrand() == Strand.POSITIVE) {
                        exon.setEnd(this.threePrimeUTR.getStart());
                    } else {
                        exon.setStart(this.threePrimeUTR.getEnd());
                    }
                }
            }
            return this.transcript;
        }

        Exon findMatchingExon(Feature cds) {
            for (Exon exon : this.exons) {
                if (!exon.contains(cds)) continue;
                return exon;
            }
            return null;
        }
    }
}

